//-----------------------------------------------------------------------------------------------------
//     This code was generated by the Wmi Delphi Code Creator (WDCC) Version [VERSIONAPP]
//     https://github.com/RRUZ/wmi-delphi-code-creator
//     Blog http://theroadtodelphi.wordpress.com/wmi-delphi-code-creator/
//     Author Rodrigo Ruz V. (RRUZ) Copyright (C) 2011-2023 
//----------------------------------------------------------------------------------------------------- 
//
//     LIABILITY DISCLAIMER
//     THIS GENERATED CODE IS DISTRIBUTED "AS IS". NO WARRANTY OF ANY KIND IS EXPRESSED OR IMPLIED.
//     YOU USE IT AT YOUR OWN RISK. THE AUTHOR NOT WILL BE LIABLE FOR DATA LOSS,
//     DAMAGES AND LOSS OF PROFITS OR ANY OTHER KIND OF LOSS WHILE USING OR MISUSING THIS CODE.
//
//----------------------------------------------------------------------------------------------------
namespace GetWMI_Info;
interface
uses
  System,
  System.Management,
  System.Text;

type
    ConsoleApp = class
    private
        class method Get[WMICLASSNAME]Info;
    public
        class method Main;
    end;

implementation

class method ConsoleApp.Main;
begin
 try
    Get[WMICLASSNAME]Info;    
 except on E: Exception do
  Console.WriteLine(String.Format('{0} Trace {1}', E.Message, E.StackTrace));
 end;
 Console.WriteLine('Press Enter to exit');
 Console.Read();
end;

[WMICLASSDESC]
class method ConsoleApp.Get[WMICLASSNAME]Info;
const
  sComputerName = 'localhost';
var
  Searcher: ManagementObjectSearcher;
  Scope: ManagementScope;
  Conn: ConnectionOptions;  
  Query: ObjectQuery; 
begin
  Conn := new ConnectionOptions();
  if sComputerName<>'localhost' then
  begin
    Conn.Username  := '';
    Conn.Password  := '';
    Conn.Authority := 'ntlmdomain:DOMAIN';
    Scope := New ManagementScope(String.Format('\\{0}\[WMINAMESPACE]',sComputerName), Conn);
  end
  else
  Scope := New ManagementScope(String.Format('\\{0}\[WMINAMESPACE]',sComputerName), nil);
  
  Scope.Connect();
  Query := New ObjectQuery('SELECT * FROM [WMICLASSNAME]'); 				
  Searcher := new ManagementObjectSearcher(Scope, Query);
    for WmiObject: ManagementObject  in Searcher.Get() do
    begin
[OXYGENECODE]	
     Console.WriteLine('');
    end;
end;
end.

