//------------------------------------------------------------------------------
//  此代码版权（除特别声明或在XREF结尾的命名空间的代码）归作者本人若汝棋茗所有
//  源代码使用协议遵循本仓库的开源协议及附加协议，若本仓库没有设置，则按MIT开源协议授权
//  CSDN博客：https://blog.csdn.net/qq_40374647
//  哔哩哔哩视频：https://space.bilibili.com/94253567
//  Gitee源代码仓库：https://gitee.com/RRQM_Home
//  Github源代码仓库：https://github.com/RRQM
//  API首页：https://touchsocket.net/
//  交流QQ群：234762506
//  感谢您的下载和使用
//------------------------------------------------------------------------------

using System;

namespace TouchSocket.WebApi
{
    /// <summary>
    /// 请求函数类型
    /// </summary>
    public enum HttpMethodType
    {
        /// <summary>
        /// 以GET方式。支持调用上下文。
        /// <para>以该方式时，所有的参数类型必须是基础类型。所有的参数来源均来自url参数。</para>
        /// </summary>
        Get = 0,

        /// <summary>
        /// 以GET方式。支持调用上下文。
        /// <para>以该方式时，所有的参数类型必须是基础类型。所有的参数来源均来自url参数。</para>
        /// </summary>
        [Obsolete("此配置已被弃用，请使用Get代替", true)]
        GET = 0,

        /// <summary>
        /// 以Post方式。支持调用上下文。
        /// <para>以该方式时，可以应对以下情况：</para>
        /// <list type="bullet">
        /// <item>仅有一个参数时，该参数可以为任意类型，且参数来源为Body</item>
        /// <item>当有多个参数时，最后一个参数可以为任意类型，且参数来源为Body，其余参数均必须是基础类型，且来自url参数。</item>
        /// </list>
        /// </summary>
        Post = 1,

        /// <summary>
        /// 以Post方式。支持调用上下文。
        /// <para>以该方式时，可以应对以下情况：</para>
        /// <list type="bullet">
        /// <item>仅有一个参数时，该参数可以为任意类型，且参数来源为Body</item>
        /// <item>当有多个参数时，最后一个参数可以为任意类型，且参数来源为Body，其余参数均必须是基础类型，且来自url参数。</item>
        /// </list>
        /// </summary>
        [Obsolete("此配置已被弃用，请使用Get代替", true)]
        POST = 1,

        /// <summary>
        /// 以Put方式。支持调用上下文。
        /// </summary>
        Put = 2,

        /// <summary>
        /// 以Delete方式。支持调用上下文。
        /// </summary>
        Delete = 3
    }
}