//------------------------------------------------------------------------------
//  此代码版权（除特别声明或在XREF结尾的命名空间的代码）归作者本人若汝棋茗所有
//  源代码使用协议遵循本仓库的开源协议及附加协议，若本仓库没有设置，则按MIT开源协议授权
//  CSDN博客：https://blog.csdn.net/qq_40374647
//  哔哩哔哩视频：https://space.bilibili.com/94253567
//  Gitee源代码仓库：https://gitee.com/RRQM_Home
//  Github源代码仓库：https://github.com/RRQM
//  API首页：https://touchsocket.net/
//  交流QQ群：234762506
//  感谢您的下载和使用
//------------------------------------------------------------------------------

using System.IO.Ports;

namespace TouchSocket.SerialPorts
{
    /// <summary>
    /// 串口配置
    /// </summary>
    public class SerialPortOption
    {
        /// <summary>
        /// 波特率
        /// </summary>
        public int BaudRate { get; set; } = 9600;

        /// <summary>
        /// 数据位
        /// </summary>
        public int DataBits { get; set; } = 8;

        /// <summary>
        /// 校验位
        /// </summary>
        public Parity Parity { get; set; } = Parity.None;

        /// <summary>
        /// COM
        /// </summary>
        public string PortName { get; set; } = "COM1";

        /// <summary>
        /// 停止位
        /// </summary>
        public StopBits StopBits { get; set; } = StopBits.One;

        ///<inheritdoc cref = "SerialPort.Handshake" />
        public Handshake Handshake { get; set; }

        ///<inheritdoc cref = "SerialPort.DtrEnable" />
        public bool DtrEnable { get; set; }

        ///<inheritdoc cref = "SerialPort.RtsEnable" />
        public bool RtsEnable { get; set; }

        /// <inheritdoc/>
        public override string ToString()
        {
            return $"{this.PortName}[{this.BaudRate},{this.DataBits},{this.StopBits},{this.Parity}]";
        }
    }
}