//------------------------------------------------------------------------------
//  此代码版权（除特别声明或在XREF结尾的命名空间的代码）归作者本人若汝棋茗所有
//  源代码使用协议遵循本仓库的开源协议及附加协议，若本仓库没有设置，则按MIT开源协议授权
//  CSDN博客：https://blog.csdn.net/qq_40374647
//  哔哩哔哩视频：https://space.bilibili.com/94253567
//  Gitee源代码仓库：https://gitee.com/RRQM_Home
//  Github源代码仓库：https://github.com/RRQM
//  API首页：https://touchsocket.net/
//  交流QQ群：234762506
//  感谢您的下载和使用
//------------------------------------------------------------------------------

using TouchSocket.Core;

namespace TouchSocket.Dmtp.FileTransfer
{
    internal class WaitFinishedPackage : WaitRouterPackage
    {
        public ResultCode Code { get; set; }
        public Metadata Metadata { get; set; }
        public int ResourceHandle { get; set; }

        public override void PackageBody<TByteBlock>(ref TByteBlock byteBlock)
        {
            base.PackageBody(ref byteBlock);
            byteBlock.WriteInt32(this.ResourceHandle);
            byteBlock.WritePackage(this.Metadata);
            byteBlock.WriteByte((byte)this.Code);
        }

        public override void UnpackageBody<TByteBlock>(ref TByteBlock byteBlock)
        {
            base.UnpackageBody(ref byteBlock);
            this.ResourceHandle = byteBlock.ReadInt32();
            this.Metadata = byteBlock.ReadPackage<Metadata>();
            this.Code = (ResultCode)byteBlock.ReadByte();
        }
    }
}