//------------------------------------------------------------------------------
//  此代码版权（除特别声明或在XREF结尾的命名空间的代码）归作者本人若汝棋茗所有
//  源代码使用协议遵循本仓库的开源协议及附加协议，若本仓库没有设置，则按MIT开源协议授权
//  CSDN博客：https://blog.csdn.net/qq_40374647
//  哔哩哔哩视频：https://space.bilibili.com/94253567
//  Gitee源代码仓库：https://gitee.com/RRQM_Home
//  Github源代码仓库：https://github.com/RRQM
//  API首页：https://touchsocket.net/
//  交流QQ群：234762506
//  感谢您的下载和使用
//------------------------------------------------------------------------------

namespace TouchSocket.Core
{

    /// <summary>
    /// 配置事件参数类，继承自PluginEventArgs
    /// 该类用于封装配置相关的事件参数，主要携带了TouchSocket配置信息
    /// </summary>
    public class ConfigEventArgs : PluginEventArgs
    {
        /// <summary>
        /// 初始化ConfigEventArgs类的实例
        /// </summary>
        /// <param name="config">TouchSocket配置对象</param>
        public ConfigEventArgs(TouchSocketConfig config)
        {
            this.Config = config;
        }

        /// <summary>
        /// 具体配置
        /// </summary>
        public TouchSocketConfig Config { get; }
    }
}