# Contributing to `MOMOMIA` :) 
  
 A big welcome and thank you for considering contributing to **Momomia** open source project! 😀
  
 Reading and following these guidelines will help us make the contribution process easy and effective for everyone involved. It also  communicates that you agree to respect the time of the developers managing and developing these open source projects. In return, we 
 will reciprocate that respect by addressing your issue, assessing changes, and helping you finalize your pull requests. 
  
 ## Quicklinks 
  
 * [Getting Started](#gettingstarted)
 * [Issues](#issues)
 * [Pull Requests](#pullrequests)
  
 ## Getting Started 
  
 Contributions are made to this repository via Issues and Pull Requests (PRs). A few general guidelines for contributing that cover both: 
  
 - Search for existing Issues and PRs before creating your own. This will help both contributor & maintainer to make out things proper & effective.
 - We work hard to makes sure issues are handled in a timely manner but, depending on the impact, it could take a while to investigate the root cause. A friendly ping in the comment thread to the maintainer or a contributor can help draw attention if your issue is blocking.  
  
 ### Issues 
 Issues should be used to :
 * Report problems with the library 
 * Request for a new feature 
 * To discuss potential changes before a PR is created 

 If you find an existing Issue that addresses the similar problem you're having please add your own reproduction information to 
 the existing issue rather than creating a new one.
 You can check the existing issues and create new issues from [here](https://github.com/RIKI-05/MOMOMIA/issues)
  
 ### Pull Requests 
  
 PRs to our repository are always welcome and can be a quick way to get your fix or improvement slated for the next release. In general,  PRs should :
  
 - Only fix/add the functionality in question *OR* address wide-spread whitespace/style issues, not both. 
 - Add unit or integration tests for fixed or changed functionality (if a test suite already exists).  
 - Address a single concern in the least number of changed lines as possible.  
 - Include documentation in the repo.  
 - Be accompanied by a complete Pull Request description. 
  
### Steps to create a successful PR

 1. Fork the repository to your own Github account. <br/>
 2. Clone the project to your machine. <br/>
 3. Create a branch locally under `master` with a succinct but descriptive name. <br/>
 4. Commit changes to that branch. <br/>
 5. Following any formatting and testing guidelines specific to this repo. <br/> 
 6. Push all committed changes to your fork. <br/>
 7. Open a PR in our repository and follow the PR template so that we can efficiently review the changes. <br/>
  
 #### That's it , You are all set for the journey now . 🚀
