---
title: "Quilt Mappings needs you!"
date: 2023-06-03 12:00:00 -00:00
authors:
  - ix0rai
layout: /src/layouts/Post.astro
---

Hello quilters!\
An important announcement from the Quilt Mappings team today (you can tell, because I’ve pulled out proper punctuation for the first time in my Quilt career). I’ll cut straight to the point and say it: Quilt Mappings is in need of contributions. The team and I have been working hard to keep up with Minecraft lately, but with a backlog of missing mappings since before I joined and Mojang always working to improve the game, we can’t hold up our completion by ourselves.

<!-- MORE -->

#### What's holding the team back?

The Quilt Mappings team is one of the largest in Quilt, but we’re still struggling to keep up. Why? There are a few reasons. Most of the team is simply busy and doesn’t have the time to submit new mappings, and those of us that do have time have other exciting projects to work on! We’re building an entirely new mappings toolchain, always matching to the latest snapshots, and delivering huge improvements to Enigma, the program that we use to create mappings. That’s not to say we’re not working on mappings all the time, though, and we’re always here to deliver quick reviews on pull requests!

#### Why even bother?

Quilt Mappings (or QM for short) is different from the other two sets of maintained mappings on the market: Mojmap and Yarn. We check our names against both sets constantly to make sure that we’re delivering the most accurate ones possible. Mojang names are often unintuitive, and aren’t built for modders: they’re made for the developers working on the game itself. Contrary to Mojmap, Yarn aims to deliver names that are easy to understand for modders, but since their names are not checked against Mojang’s intentions, they can sometimes be confusing and contradictory to the intended usage of the code. Both sets are excellent on their own, and QM is made to be a hybrid of the two, shipping clear, concise, and accurate names inspired by both. We’ve also implemented extensive checking for typos, Britishisms and convention violations to make sure no problematic mappings are published. Despite their drawbacks, Yarn and Mojang have 99% and 100% completion of class names respectively, and we can’t truly call ourselves the best with our measly 98.

## How can I help?

The biggest way you can help with QM is by contributing new mappings to the large swaths of the game that are missing names. All you need to help out is knowledge of Java! We have a couple cute documents already written up on how to contribute: check out our [CONTRIBUTING.md](https://github.com/QuiltMC/quilt-mappings/blob/HEAD/CONTRIBUTING.md) to find out everything you need to know before mapping! Making new mappings isn’t the only way to help, and if you want to improve our existing names, [our issue tracker](https://github.com/QuiltMC/quilt-mappings/issues) is a great place to find suggestions of names to change. However, be warned that if you change names made by me you run the risk of incurring my wrath (affectionate). Opening Enigma will immediately give you an idea of what needs doing in terms of new mappings, thanks to our handy little status icons next to each class. If a class has a check mark, you can move on, but anything with a yellow dot or red x needs your help! This adorable graph, generated by the Mapping Stats feature in Enigma, can help show you where to start. As always, we're happy to help you out with anything: using Enigma, what to name methods, where to map, etc! You can always talk to us on [our Discord](https://discord.quiltmc.org).

![A screenshot of a graph generated by Enigma to show unmapped entries, highlighting the world, entity and client packages are problem areas](/assets/img/writing/blog/2023-06-03-qm-needs-you/qm-mapping-stats.png)

If mapping the game is less your thing, we have plenty of other projects for you to help out with. We can also use the help of those experienced with Java, networking, Swing, Gradle, and even translation.
Contributors have a few great options:
1. Working on our new toolchain, which we’re calling Quilt Mapping Tools. You can help with designing the toolchain, writing Java code, designing the new mapping format, or even preparing other parts of Quilt to use QMT. The best way to find out what needs doing here is talking to our team leader, OroArmor, on [our Discord](https://discord.quiltmc.org)! You can also check the [QMT issue tracker](https://github.com/QuiltMC/quilt-mapping-tools/issues) to get a rough idea of the work that’s still in progress.
2. Helping out with our deobfuscator, Enigma! Improving Enigma helps us make mappings faster and with fewer mistakes. To help out with Enigma, you can look at *its* [issue tracker](https://github.com/QuiltMC/enigma/issues), or try to break it to help us find more bugs. In particular, we're looking for help with solving a pesky ui issue detailed [here](https://github.com/QuiltMC/enigma/issues/108). Enigma is quite a complicated program, and you can always talk to me (rai), or Martrixx on [our Discord](https://discord.quiltmc.org) if you’d like some help understanding it. Enigma is separated into four parts: a backend, a command line interface, a server, and a swing GUI, which means there’s something for every type of Java experience! If the language you speak isn’t English *or* Java, Enigma also has internationalisation support! You can add languages in the [lang](https://github.com/QuiltMC/enigma/tree/master/enigma/src/main/resources/lang) folder, or complete translation for existing languages! Compare against the `en_us` file to find missing translations.

3. Tinkering with our existing tooling! Our new set of tooling is nowhere near completion, and the stuff we use right now still needs maintenance and improvements. You can check [issues marked as “toolchain”](https://github.com/QuiltMC/quilt-mappings/issues?q=is%3Aissue+is%3Aopen+label%3A%22t%3A+toolchain%22) in our main repository to see what needs work right now.

Thank you for reading, and we'll see you on the creature trail!
\- rai
