---
title: "Quilted Fabric API: A call for contributors"
date: 2023-02-14 12:15:00 -00:00
authors:
  - Southpaw1496
layout: /src/layouts/Post.astro
---

[Quilted Fabric API](https://github.com/quiltmc/quilted-fabric-api) is our fork of Fabric API which runs alongside QSL to ensure mods using the Fabric API can work on Quilt. Since almost all Fabric mods make use of the Fabric API in some way or another, it's a critical part of Quilt's compatibility with Fabric mods, but despite this, it is largely updated and maintained by a single person:

<!-- MORE -->

![A screenshot of the Quilted Fabric API team on the Teams page, showing Ennui all by herself](/assets/img/writing/blog/2023-02-14-qfapi-call-for-contributors/lonley-ennui.png)

She could really use some help, so if you are able and have the time to spare, it would be really cool (dare I say, based?) of you to come on down and give her a hand.

## Do I need to join a team?
Absolutely not! Although contributing is often linked to joining a team, we're actually very happy to accept external contributions as well. You mustn't feel like you need to commit to joining the team before helping, and it's generally better if we get to know you and your contributions a little before accepting you onto a team if you want to be on one eventually.

## I don't feel like I know enough to contribute...
Quilt is a big project, and you might think that it's deeply complicated and requires expert skill to contribute to, but as long as you have basic Java knowledge and are willing to learn, you can do lots of things that would be a big help to us. The more people that contribute, the faster development will progress, and the more viable it is for other developers to take breaks when they need so that they can keep doing their best work. Your help is valuable, even if you don't consider yourself a skilled programmer.

## What can I do to help?
We've created [a truckload of GitHub issues](https://github.com/quiltMC/quilted-fabric-api/issues) to get you started, so have a look and find something you think you can do. If you find something you want to take on, make sure to comment on the issue so that others know you're working on it and work doesn't get done twice. If you have any questions or would like to discuss changes that you're planning to make with the developers, come and join us on the [Toolchain Discord](https://discord.quiltmc.org/toolchain).

Although this post is focused on Quilted Fabric API, we welcome contributions to all our projects, such as [Cozy](https://github.com/quiltmc/cozy-discord), [quiltmc.org](https://github.com/quiltmc/quiltmc.org), and [others](https://github.com/orgs/QuiltMC/repositories). Even if you can't code, you can still help in other ways,  for example, by [translating the website into your language](https://github.com/QuiltMC/quiltmc.org/blob/stable/LOCALIZATION.md). Join the [Toolchain Discord](https://discord.quiltmc.org/toolchain) if you're interested!
