---
title: Quilt enters Beta
date: 2022-03-22 5:30:00 -00:00
authors:
  - Southpaw1496
layout: /src/layouts/Post.astro
---

In February's final bi-weekly developer meeting (which you can listen to [as a podcast](https://anchor.fm/quiltmc-dev-meetings)), an exciting announcement was made: **Quilt is releasing its first beta on April 20th, 2022**.

<!-- MORE -->

It's a huge milestone in our development process, and we could never have done it without our [incredible teams](https://quiltmc.org/about/teams) and supporting community.

It is important to remember that this is a **beta**, not a full release. Beta software is intended for testing, ironing out issues and having space to develop features ahead of a full release. This means that a beta release will have some features missing, and may be unstable.

## Instability

Beta software is inherently unstable. This means that there could be a lot of bugs and crashes, but it also means that _anything could change at any time, with no regard for compatibility between one version and the next._

It may be frustrating, but trying different approaches and iterating is an essential part of our development, and during this pre-release stage it is essential to not be held back by backwards compatibility.

## Missing Features

Beta software is also generally missing features that will be included in the full release, and Quilt is no exception. All our projects are at a stage where we feel that they are usable, but most of them are still missing features that will be included in the final release. Namely:

- Mods will be built using a fork of Fabric's Loom with Intermediary, instead of Quilt-Gradle with Hashed MojMap.
- The Chasm bytecode transformer is not yet ready for use and will not be available.
- Loader plugins will not exist.
- QSL (Quilt Standard Libraries) will not be automatically downloaded as a dependency.
- Many QSL Modules will not be available to use.

## Why we're releasing now

To address the elephant in the room, we're not releasing Quilt on 4/20 for the memes. April 20th is actually the one-year anniversary of the Community Discord server, a very significant event in Quilt's history. Besides this, we're releasing our tools in an unfinished state for two reasons:

- Quilt is relatively unknown outside its community, and we hope that by showing that Quilt is more than just an idea, the project will gain some traction, and start being taken more seriously by people in the modding sphere.
- Both our developers and our (future) users are very important to us, and we want your feedback and ideas on how to improve what we've made, while we still have the flexibility of being in the development stage to change and break things, without having to worry about backwards compatibility.

## Stay in the Know

While we are currently confident that we can make the April 20th target, the truth is that software development is often unpredictable, and estimates aren't always representative of when a target is met. If you want to stay up-to-date with developments, we recommend joining our [Community Discord Server](https://discord.quiltmc.org), and/or [following us on Twitter](https://twitter.com/Quilt_MC).

You can even [subscribe to this blog via RSS](https://quiltmc.org/feed.xml) and get updates delivered straight to your RSS reader of choice.

We also hold a Public Developer Meeting on the [Toolchain Discord Server](https://discord.quiltmc.org/toolchain) every second Saturday at 5PM UTC, where the teams get together and discuss the progress made on their respective projects, and also answer questions from the community. Even though it's called a Developer meeting, anyone interested in Quilt's future development is welcome.

## Get Involved

If you want to get involved, we could always use some extra help. A list of current openings for positions on our various teams can be found on the [Openings page](https://quiltmc.org/openings), but if none of them speak to you, or if you want to contribute without joining a team, the best thing to do is to join the [Toolchain Discord Server](https://discord.quiltmc.org/toolchain) and offer your expertise.

## Conclusion

We'd like to thank everyone who has come with us on the journey so far, including our developers and our wonderful community. This is Quilt's biggest step since we ran out of GitHub Actions minutes and had to go public, and we never could've done it without all of you.

Quilt is closer than ever, and we can't wait.
