---
title: "This is Quilt"
date: 2021-04-20 9:00:00 -00:00
authors:
  - Haven King
  - ToffeeMax
layout: /src/layouts/Post.astro
---

This is the Quilt Project: An open, community-driven modding toolchain designed primarily for Minecraft. Quilt builds on many of the technologies developed by [the Fabric Project](https://fabricmc.net) and is designed to take what worked well and expand on it further.

<!-- MORE -->

## Why the Fork?

While the Fabric Project has made significant progress towards an open and advanced mod loader, it has recently slowed down in technical innovation and failed to address several organizational issues. There are a number of changes the Quilt Project will put into place in the future to differentiate ourselves:

- Governmental Structure -- Quilt's organizational structure has been designed with openness in mind; no one person holds all the keys.
- Separation of Concerns -- Those in charge of technical concerns should not be making important community decisions, and vice versa. Quilt's teams each control a very specific aspect of the project.
- Quilt Loader Plugins -- Will allow other parties to change mod loading behavior in new and exciting ways.
- Dependency Downloading -- Users will no longer have to download every single dependency for each of their mods.
- Cleaner Bytecode Modifications -- A safe, deterministic alternative to "Mixin" or modifying bytecode by hand.
- Faster Iteration & Experimentation -- The Quilt project aims to fail fast. We would rather try something and fix it then spend countless months debating whether to move forward with it in the first place.

## Important Documents and RFCs

Quilt makes use of a Request for Comment system to drive major organizational changes. The RFCs are designed to make clear what changes are on the horizon, allow for comment from the community and as a maintained location for how specific parts of The Quilt Project work (eg Governance).

You can view these documents (accepted and not) via our [GitHub Repository](https://github.com/QuiltMC/rfcs); please use this space to submit new RFCs and comment on currently open ones.

The process of RFCs is outlined in [RFC-0001](https://github.com/QuiltMC/rfcs/blob/master/structure/0001-rfc-process.md).

## Who is involved?

To view an approximate membership, our [GitHub organization](https://github.com/QuiltMC) is a good starting place. This list is not exhaustive as it may not include members who are part of the community team.

## Can I mod on Fabric and Quilt?

Fabric mods will be able to run on Quilt initially. There may be a point in the future where this is no longer possible.

## I have more questions!

We have written a FAQ which hopes to provide answers to some common questions. If something is not covered there, please ask on our [Discord](https://discord.quiltmc.org).
