//
//  ========================================================================
//  Copyright (c) 1995-2015 Mort Bay Consulting Pty. Ltd.
//  ------------------------------------------------------------------------
//  All rights reserved. This program and the accompanying materials
//  are made available under the terms of the Eclipse Public License v1.0
//  and Apache License v2.0 which accompanies this distribution.
//
//      The Eclipse Public License is available at
//      http://www.eclipse.org/legal/epl-v10.html
//
//      The Apache License v2.0 is available at
//      http://www.opensource.org/licenses/apache2.0.php
//
//  You may elect to redistribute this code under either of these licenses.
//  ========================================================================
//

package org.eclipse.jetty.util.security;

/* ------------------------------------------------------------ */
/**
 * Password utility class.
 * 
 * This utility class gets a password or pass phrase either by:
 * 
 * <PRE>
 *  + Password is set as a system property.
 *  + The password is prompted for and read from standard input
 *  + A program is run to get the password.
 * </pre>
 * 
 * Passwords that begin with OBF: are de obfuscated. Passwords can be obfuscated
 * by run org.eclipse.util.Password as a main class. Obfuscated password are
 * required if a system needs to recover the full password (eg. so that it may
 * be passed to another system). They are not secure, but prevent casual
 * observation.
 * <p>
 * Passwords that begin with CRYPT: are oneway encrypted with UnixCrypt. The
 * real password cannot be retrieved, but comparisons can be made to other
 * passwords. A Crypt can be generated by running org.eclipse.util.UnixCrypt as
 * a main class, passing password and then the username. Checksum passwords are
 * a secure(ish) way to store passwords that only need to be checked rather than
 * recovered. Note that it is not strong security - specially if simple
 * passwords are used.
 * 
 * 
 */
public class Password
{
    private String _pw;

    /* ------------------------------------------------------------ */
    @Override
    public String toString()
    {
        return _pw;
    }

    /* ------------------------------------------------------------ */
    @Override
    public boolean equals(Object o)
    {
        if (this == o) 
            return true;

        if (null == o) 
            return false;

        if (o instanceof Password)
        {
            Password p = (Password) o;
            //noinspection StringEquality
            return p._pw == _pw || (null != _pw && _pw.equals(p._pw));
        }

        if (o instanceof String) 
            return o.equals(_pw);

        return false;
    }
}
