/*
 * Decompiled with CFR 0.152.
 */
package soot.xml;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.G;
import soot.Local;
import soot.Main;
import soot.Modifier;
import soot.NormalUnitPrinter;
import soot.Scene;
import soot.Singletons;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Trap;
import soot.Type;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.ValueBox;
import soot.jimple.IdentityStmt;
import soot.toolkits.graph.ExceptionalUnitGraphFactory;
import soot.toolkits.scalar.SimpleLiveLocals;
import soot.util.Chain;
import soot.xml.XMLNode;
import soot.xml.XMLRoot;

public class XMLPrinter {
    private static final Logger logger = LoggerFactory.getLogger(XMLPrinter.class);
    public static final String xmlHeader = "<?xml version=\"1.0\" ?>\n";
    public static final String dtdHeader = "<!DOCTYPE jil SYSTEM \"http://www.sable.mcgill.ca/~flynn/jil/jil10.dtd\">\n";
    public XMLRoot root;

    public XMLPrinter(Singletons.Global g2) {
    }

    public static XMLPrinter v() {
        return G.v().soot_xml_XMLPrinter();
    }

    public String toString() {
        if (this.root != null) {
            return this.root.toString();
        }
        throw new RuntimeException("Error generating XML!");
    }

    public XMLNode addElement(String name) {
        return this.addElement(name, "", "", "");
    }

    public XMLNode addElement(String name, String value) {
        return this.addElement(name, value, "", "");
    }

    public XMLNode addElement(String name, String value, String[] attributes) {
        return this.addElement(name, value, attributes, null);
    }

    public XMLNode addElement(String name, String value, String attribute, String attributeValue) {
        return this.addElement(name, value, new String[]{attribute}, new String[]{attributeValue});
    }

    public XMLNode addElement(String name, String value, String[] attributes, String[] values) {
        return this.root.addElement(name, value, attributes, values);
    }

    public void printJimpleStyleTo(SootClass cl, PrintWriter out) {
        this.root = new XMLRoot();
        Scene sc = Scene.v();
        XMLNode xmlRootNode = this.root.addElement("jil");
        StringBuilder cmdlineStr = new StringBuilder();
        for (String element : Main.v().cmdLineArgs) {
            cmdlineStr.append(element).append(' ');
        }
        String string = new Date().toString();
        XMLNode xmlHistoryNode = xmlRootNode.addChild("history");
        xmlHistoryNode.addAttribute("created", string);
        xmlHistoryNode.addChild("soot", new String[]{"version", "command", "timestamp"}, new String[]{Main.versionString, cmdlineStr.toString().trim(), string});
        XMLNode xmlClassNode = xmlRootNode.addChild("class", new String[]{"name"}, new String[]{sc.quotedNameOf(cl.getName())});
        if (!cl.getPackageName().isEmpty()) {
            xmlClassNode.addAttribute("package", cl.getPackageName());
        }
        if (cl.hasSuperclass()) {
            xmlClassNode.addAttribute("extends", sc.quotedNameOf(cl.getSuperclass().getName()));
        }
        XMLNode xmlTempNode = xmlClassNode.addChild("modifiers");
        StringTokenizer st = new StringTokenizer(Modifier.toString(cl.getModifiers()));
        while (st.hasMoreTokens()) {
            xmlTempNode.addChild("modifier", new String[]{"name"}, new String[]{st.nextToken()});
        }
        xmlTempNode.addAttribute("count", String.valueOf(xmlTempNode.getNumberOfChildren()));
        XMLNode xmlTempNode2 = xmlClassNode.addChild("interfaces", "", new String[]{"count"}, new String[]{String.valueOf(cl.getInterfaceCount())});
        for (SootClass sootClass : cl.getInterfaces()) {
            xmlTempNode2.addChild("implements", "", new String[]{"class"}, new String[]{sc.quotedNameOf(sootClass.getName())});
        }
        XMLNode xmlTempNode3 = xmlClassNode.addChild("fields", "", new String[]{"count"}, new String[]{String.valueOf(cl.getFieldCount())});
        int i = 0;
        for (SootField f : cl.getFields()) {
            if (f.isPhantom()) continue;
            XMLNode xmlFieldNode = xmlTempNode3.addChild("field", "", new String[]{"id", "name", "type"}, new String[]{String.valueOf(i++), f.getName(), f.getType().toString()});
            XMLNode xmlModifiersNode = xmlFieldNode.addChild("modifiers");
            StringTokenizer st2 = new StringTokenizer(Modifier.toString(f.getModifiers()));
            while (st2.hasMoreTokens()) {
                xmlModifiersNode.addChild("modifier", new String[]{"name"}, new String[]{st2.nextToken()});
            }
            xmlModifiersNode.addAttribute("count", String.valueOf(xmlModifiersNode.getNumberOfChildren()));
        }
        XMLNode methodsNode = xmlClassNode.addChild("methods", new String[]{"count"}, new String[]{String.valueOf(cl.getMethodCount())});
        Iterator<SootMethod> methodIt = cl.methodIterator();
        while (methodIt.hasNext()) {
            SootMethod sootMethod = methodIt.next();
            if (sootMethod.isPhantom() || Modifier.isAbstract(sootMethod.getModifiers()) || Modifier.isNative(sootMethod.getModifiers())) continue;
            if (!sootMethod.hasActiveBody()) {
                throw new RuntimeException("method " + sootMethod.getName() + " has no active body!");
            }
            Body body = sootMethod.getActiveBody();
            body.validate();
            this.printStatementsInBody(body, methodsNode);
        }
        out.println(this.toString());
    }

    private void printStatementsInBody(Body body, XMLNode methodsNode) {
        NormalUnitPrinter up = new NormalUnitPrinter(body);
        Map<Unit, String> stmtToName = up.labels();
        UnitPatchingChain units = body.getUnits();
        String currentLabel = "default";
        long labelCount = 0L;
        String cleanMethodName = XMLPrinter.cleanMethod(body.getMethod().getName());
        XMLNode methodNode = methodsNode.addChild("method", new String[]{"name", "returntype", "class"}, new String[]{cleanMethodName, body.getMethod().getReturnType().toString(), body.getMethod().getDeclaringClass().getName()});
        String declarationStr = body.getMethod().getDeclaration().trim();
        methodNode.addChild("declaration", XMLPrinter.toCDATA(declarationStr), new String[]{"length"}, new String[]{String.valueOf(declarationStr.length())});
        XMLNode parametersNode = methodNode.addChild("parameters", new String[]{"method"}, new String[]{cleanMethodName});
        XMLNode localsNode = methodNode.addChild("locals");
        XMLNode labelsNode = methodNode.addChild("labels");
        XMLNode stmtsNode = methodNode.addChild("statements");
        XMLLabel xmlLabel = new XMLLabel(labelCount, cleanMethodName, currentLabel);
        labelsNode.addChild("label", new String[]{"id", "name", "method"}, new String[]{String.valueOf(labelCount++), currentLabel, cleanMethodName});
        SimpleLiveLocals sll = new SimpleLiveLocals(ExceptionalUnitGraphFactory.createExceptionalUnitGraph(body));
        ArrayList<String> useList = new ArrayList<String>();
        ArrayList<ArrayList<Long>> useDataList = new ArrayList<ArrayList<Long>>();
        ArrayList<String> defList = new ArrayList<String>();
        ArrayList<ArrayList<Long>> defDataList = new ArrayList<ArrayList<Long>>();
        ArrayList<ArrayList> paramData = new ArrayList<ArrayList>();
        ArrayList<XMLLabel> xmlLabelsList = new ArrayList<XMLLabel>();
        long statementCount = 0L;
        long maxStmtCount = 0L;
        long labelID = 0L;
        for (Unit currentStmt : units) {
            Local val;
            int i;
            ArrayList<Long> tempArrayList;
            String local;
            if (stmtToName.containsKey(currentStmt)) {
                currentLabel = stmtToName.get(currentStmt);
                xmlLabel.stmtCount = labelID;
                xmlLabel.stmtPercentage = (long)((float)labelID / (float)units.size() * 100.0f);
                if (xmlLabel.stmtPercentage > maxStmtCount) {
                    maxStmtCount = xmlLabel.stmtPercentage;
                }
                xmlLabelsList.add(xmlLabel);
                xmlLabel = new XMLLabel(labelCount, cleanMethodName, currentLabel);
                labelsNode.addChild("label", new String[]{"id", "name", "method"}, new String[]{String.valueOf(labelCount), currentLabel, cleanMethodName});
                ++labelCount;
                labelID = 0L;
            }
            XMLNode stmtNode = stmtsNode.addChild("statement", new String[]{"id", "label", "method", "labelid"}, new String[]{String.valueOf(statementCount), currentLabel, cleanMethodName, String.valueOf(labelID)});
            XMLNode sootstmtNode = stmtNode.addChild("soot_statement", new String[]{"branches", "fallsthrough"}, new String[]{XMLPrinter.boolToString(currentStmt.branches()), XMLPrinter.boolToString(currentStmt.fallsThrough())});
            int j = 0;
            for (ValueBox box : currentStmt.getUseBoxes()) {
                if (!(box.getValue() instanceof Local)) continue;
                local = XMLPrinter.cleanLocal(box.getValue().toString());
                sootstmtNode.addChild("uses", new String[]{"id", "local", "method"}, new String[]{String.valueOf(j), local, cleanMethodName});
                ++j;
                tempArrayList = null;
                int useIndex = useList.indexOf(local);
                if (useIndex == -1) {
                    useDataList.add(tempArrayList);
                    useIndex = useList.size();
                    useList.add(local);
                }
                if (useDataList.size() <= useIndex) continue;
                tempArrayList = (ArrayList<Long>)useDataList.get(useIndex);
                if (tempArrayList == null) {
                    tempArrayList = new ArrayList<Long>();
                }
                tempArrayList.add(statementCount);
                useDataList.set(useIndex, tempArrayList);
            }
            j = 0;
            for (ValueBox box : currentStmt.getDefBoxes()) {
                if (!(box.getValue() instanceof Local)) continue;
                local = XMLPrinter.cleanLocal(box.getValue().toString());
                sootstmtNode.addChild("defines", new String[]{"id", "local", "method"}, new String[]{String.valueOf(j), local, cleanMethodName});
                ++j;
                tempArrayList = null;
                int defIndex = defList.indexOf(local);
                if (defIndex == -1) {
                    defDataList.add(tempArrayList);
                    defIndex = defList.size();
                    defList.add(local);
                }
                if (defDataList.size() <= defIndex) continue;
                tempArrayList = (ArrayList<Long>)defDataList.get(defIndex);
                if (tempArrayList == null) {
                    tempArrayList = new ArrayList<Long>();
                }
                tempArrayList.add(statementCount);
                defDataList.set(defIndex, tempArrayList);
            }
            List<Local> liveLocalsIn = sll.getLiveLocalsBefore(currentStmt);
            List<Local> liveLocalsOut = sll.getLiveLocalsAfter(currentStmt);
            XMLNode livevarsNode = sootstmtNode.addChild("livevariables", new String[]{"incount", "outcount"}, new String[]{String.valueOf(liveLocalsIn.size()), String.valueOf(liveLocalsOut.size())});
            ListIterator<Local> it = liveLocalsIn.listIterator();
            while (it.hasNext()) {
                i = it.nextIndex();
                val = it.next();
                livevarsNode.addChild("in", new String[]{"id", "local", "method"}, new String[]{String.valueOf(i), XMLPrinter.cleanLocal(val.toString()), cleanMethodName});
            }
            it = liveLocalsOut.listIterator();
            while (it.hasNext()) {
                i = it.nextIndex();
                val = it.next();
                livevarsNode.addChild("out", new String[]{"id", "local", "method"}, new String[]{String.valueOf(i), XMLPrinter.cleanLocal(val.toString()), cleanMethodName});
            }
            int e = body.getMethod().getParameterCount();
            for (int i2 = 0; i2 < e; ++i2) {
                paramData.add(new ArrayList());
            }
            currentStmt.toString(up);
            String jimpleStr = up.toString().trim();
            if (currentStmt instanceof IdentityStmt && jimpleStr.contains("@parameter")) {
                int paramIndex;
                ArrayList tempVec;
                String tempStr = jimpleStr.substring(jimpleStr.indexOf("@parameter") + 10);
                int idx = tempStr.indexOf(58);
                if (idx != -1) {
                    tempStr = tempStr.substring(0, idx).trim();
                }
                if ((idx = tempStr.indexOf(32)) != -1) {
                    tempStr = tempStr.substring(0, idx).trim();
                }
                if ((tempVec = (ArrayList)paramData.get(paramIndex = Integer.valueOf(tempStr).intValue())) != null) {
                    tempVec.add(Long.toString(statementCount));
                }
                paramData.set(paramIndex, tempVec);
            }
            sootstmtNode.addChild("jimple", XMLPrinter.toCDATA(jimpleStr), new String[]{"length"}, new String[]{String.valueOf(jimpleStr.length() + 1)});
            ++labelID;
            ++statementCount;
        }
        stmtsNode.addAttribute("count", String.valueOf(statementCount));
        List<Type> parameterTypes = body.getMethod().getParameterTypes();
        parametersNode.addAttribute("count", String.valueOf(parameterTypes.size()));
        ListIterator<Type> it = parameterTypes.listIterator();
        while (it.hasNext()) {
            int i = it.nextIndex();
            Type val = it.next();
            XMLNode paramNode = parametersNode.addChild("parameter", new String[]{"id", "type", "method", "name"}, new String[]{String.valueOf(i), String.valueOf(val), cleanMethodName, "_parameter" + i});
            XMLNode sootparamNode = paramNode.addChild("soot_parameter");
            ArrayList tempVec = (ArrayList)paramData.get(i);
            ListIterator itk = tempVec.listIterator();
            while (itk.hasNext()) {
                int k = itk.nextIndex();
                String valk = (String)itk.next();
                sootparamNode.addChild("use", new String[]{"id", "line", "method"}, new String[]{String.valueOf(k), valk, cleanMethodName});
            }
            sootparamNode.addAttribute("uses", String.valueOf(tempVec.size()));
        }
        xmlLabel.stmtCount = labelID;
        xmlLabel.stmtPercentage = (long)((float)labelID / (float)units.size() * 100.0f);
        if (xmlLabel.stmtPercentage > maxStmtCount) {
            maxStmtCount = xmlLabel.stmtPercentage;
        }
        xmlLabelsList.add(xmlLabel);
        Chain<Local> locals = body.getLocals();
        ArrayList<String> localTypes = new ArrayList<String>();
        ArrayList<ArrayList> typedLocals = new ArrayList<ArrayList>();
        ArrayList<Integer> typeCounts = new ArrayList<Integer>();
        int j = 0;
        int currentType = 0;
        for (Local localData : locals) {
            Long val;
            int i;
            ListIterator it2;
            int useCount = 0;
            int defineCount = 0;
            String localType = localData.getType().toString();
            if (!localTypes.contains(localType)) {
                localTypes.add(localType);
                typedLocals.add(new ArrayList());
                typeCounts.add(0);
            }
            String local = XMLPrinter.cleanLocal(localData.toString());
            XMLNode localNode = new XMLNode("local", "", new String[]{"id", "method", "name", "type"}, new String[]{String.valueOf(j), cleanMethodName, local, localType});
            XMLNode sootlocalNode = localNode.addChild("soot_local");
            currentType = 0;
            Iterator it3 = localTypes.listIterator();
            while (it3.hasNext()) {
                int k;
                String val2 = (String)it3.next();
                if (!localType.equalsIgnoreCase(val2)) continue;
                currentType = k = it3.previousIndex();
                typeCounts.set(k, (Integer)typeCounts.get(k) + 1);
                break;
            }
            for (String nextUse : useList) {
                if (!local.equalsIgnoreCase(nextUse)) continue;
                ArrayList tempArrayList = (ArrayList)useDataList.get(useList.indexOf(local));
                useCount = tempArrayList.size();
                it2 = tempArrayList.listIterator();
                while (it2.hasNext()) {
                    i = it2.nextIndex();
                    val = (Long)it2.next();
                    sootlocalNode.addChild("use", new String[]{"id", "line", "method"}, new String[]{String.valueOf(i), String.valueOf(val), cleanMethodName});
                }
                break block10;
            }
            for (String nextDef : defList) {
                if (!local.equalsIgnoreCase(nextDef)) continue;
                ArrayList tempArrayList = (ArrayList)defDataList.get(defList.indexOf(local));
                defineCount = tempArrayList.size();
                it2 = tempArrayList.listIterator();
                while (it2.hasNext()) {
                    i = it2.nextIndex();
                    val = (Long)it2.next();
                    sootlocalNode.addChild("definition", new String[]{"id", "line", "method"}, new String[]{String.valueOf(i), String.valueOf(val), cleanMethodName});
                }
                break block12;
            }
            sootlocalNode.addAttribute("uses", String.valueOf(useCount));
            sootlocalNode.addAttribute("defines", String.valueOf(defineCount));
            ArrayList list = (ArrayList)typedLocals.get(currentType);
            list.add(localNode);
            typedLocals.set(currentType, list);
            localsNode.addChild((XMLNode)localNode.clone());
            ++j;
        }
        localsNode.addAttribute("count", String.valueOf(locals.size()));
        XMLNode typesNode = localsNode.addChild("types", new String[]{"count"}, new String[]{String.valueOf(localTypes.size())});
        ListIterator it4 = localTypes.listIterator();
        while (it4.hasNext()) {
            int i = it4.nextIndex();
            String val = (String)it4.next();
            XMLNode typeNode = typesNode.addChild("type", new String[]{"id", "type", "count"}, new String[]{String.valueOf(i), val, String.valueOf(typeCounts.get(i))});
            for (XMLNode n : (ArrayList)typedLocals.get(i)) {
                typeNode.addChild(n);
            }
        }
        labelsNode.addAttribute("count", String.valueOf(labelCount));
        XMLNode current = labelsNode.child;
        for (XMLLabel tempLabel : xmlLabelsList) {
            tempLabel.stmtPercentage = (long)((float)tempLabel.stmtPercentage / (float)maxStmtCount * 100.0f);
            if (current == null) continue;
            current.addAttribute("stmtcount", String.valueOf(tempLabel.stmtCount));
            current.addAttribute("stmtpercentage", String.valueOf(tempLabel.stmtPercentage));
            current = current.next;
        }
        int j2 = 0;
        XMLNode exceptionsNode = methodNode.addChild("exceptions");
        for (Trap trap : body.getTraps()) {
            XMLNode catchNode = exceptionsNode.addChild("exception", new String[]{"id", "method", "type"}, new String[]{String.valueOf(j2++), cleanMethodName, Scene.v().quotedNameOf(trap.getException().getName())});
            catchNode.addChild("begin", new String[]{"label"}, new String[]{stmtToName.get(trap.getBeginUnit())});
            catchNode.addChild("end", new String[]{"label"}, new String[]{stmtToName.get(trap.getEndUnit())});
            catchNode.addChild("handler", new String[]{"label"}, new String[]{stmtToName.get(trap.getHandlerUnit())});
        }
        exceptionsNode.addAttribute("count", String.valueOf(exceptionsNode.getNumberOfChildren()));
    }

    private static String cleanMethod(String str) {
        return str.trim().replace('<', '_').replace('>', '_');
    }

    private static String cleanLocal(String str) {
        return str.trim();
    }

    private static String toCDATA(String str) {
        return "<![CDATA[" + str.replaceAll("]]>", "]]&gt;") + "]]>";
    }

    private static String boolToString(boolean bool) {
        return bool ? "true" : "false";
    }

    private static class XMLLabel {
        public final long id;
        public final String methodName;
        public final String label;
        public long stmtCount;
        public long stmtPercentage;

        public XMLLabel(long in_id, String in_methodName, String in_label) {
            this.id = in_id;
            this.methodName = in_methodName;
            this.label = in_label;
        }
    }
}

