/*
 * Decompiled with CFR 0.152.
 */
package soot.xml;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import soot.Body;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Unit;
import soot.ValueBox;
import soot.tagkit.Host;
import soot.tagkit.JimpleLineNumberTag;
import soot.tagkit.KeyTag;
import soot.tagkit.SourceFileTag;
import soot.tagkit.Tag;
import soot.xml.Attribute;
import soot.xml.Key;

public class TagCollector {
    private final ArrayList<Attribute> attributes = new ArrayList();
    private final ArrayList<Key> keys = new ArrayList();

    public boolean isEmpty() {
        return this.attributes.isEmpty() && this.keys.isEmpty();
    }

    public void collectTags(SootClass sc) {
        this.collectTags(sc, true);
    }

    public void collectTags(SootClass sc, boolean includeBodies) {
        this.collectClassTags(sc);
        for (SootField sf : sc.getFields()) {
            this.collectFieldTags(sf);
        }
        for (SootMethod sm : sc.getMethods()) {
            this.collectMethodTags(sm);
            if (!includeBodies || !sm.hasActiveBody()) continue;
            this.collectBodyTags(sm.getActiveBody());
        }
    }

    public void collectKeyTags(SootClass sc) {
        for (Tag next : sc.getTags()) {
            if (!(next instanceof KeyTag)) continue;
            KeyTag kt = (KeyTag)next;
            Key k = new Key(kt.red(), kt.green(), kt.blue(), kt.key());
            k.aType(kt.analysisType());
            this.keys.add(k);
        }
    }

    public void printKeys(PrintWriter writerOut) {
        for (Key k : this.keys) {
            k.print(writerOut);
        }
    }

    private void addAttribute(Attribute a) {
        if (!a.isEmpty()) {
            this.attributes.add(a);
        }
    }

    private void collectHostTags(Host h2) {
        this.collectHostTags(h2, t2 -> true);
    }

    private void collectHostTags(Host h2, Predicate<Tag> include) {
        List<Tag> tags = h2.getTags();
        if (!tags.isEmpty()) {
            Attribute a = new Attribute();
            for (Tag t2 : tags) {
                if (!include.test(t2)) continue;
                a.addTag(t2);
            }
            this.addAttribute(a);
        }
    }

    public void collectClassTags(SootClass sc) {
        this.collectHostTags(sc, t2 -> !(t2 instanceof SourceFileTag));
    }

    public void collectFieldTags(SootField sf) {
        this.collectHostTags(sf);
    }

    public void collectMethodTags(SootMethod sm) {
        if (sm.hasActiveBody()) {
            this.collectHostTags(sm);
        }
    }

    public synchronized void collectBodyTags(Body b) {
        for (Unit u : b.getUnits()) {
            Attribute ua = new Attribute();
            JimpleLineNumberTag jlnt = null;
            for (Tag t2 : u.getTags()) {
                ua.addTag(t2);
                if (!(t2 instanceof JimpleLineNumberTag)) continue;
                jlnt = (JimpleLineNumberTag)t2;
            }
            this.addAttribute(ua);
            for (ValueBox vb : u.getUseAndDefBoxes()) {
                if (vb.getTags().isEmpty()) continue;
                Attribute va = new Attribute();
                for (Tag t3 : vb.getTags()) {
                    va.addTag(t3);
                    if (jlnt == null) continue;
                    va.addTag(jlnt);
                }
                this.addAttribute(va);
            }
        }
    }

    public void printTags(PrintWriter writerOut) {
        for (Attribute a : this.attributes) {
            a.print(writerOut);
        }
    }
}

