/*
 * Decompiled with CFR 0.152.
 */
package soot.xml;

import java.io.PrintWriter;
import java.util.ArrayList;
import soot.tagkit.ColorTag;
import soot.tagkit.Host;
import soot.tagkit.JimpleLineNumberTag;
import soot.tagkit.LineNumberTag;
import soot.tagkit.LinkTag;
import soot.tagkit.PositionTag;
import soot.tagkit.SourceLnPosTag;
import soot.tagkit.StringTag;
import soot.tagkit.Tag;
import soot.xml.ColorAttribute;
import soot.xml.LinkAttribute;
import soot.xml.StringAttribute;

public class Attribute {
    private ArrayList<ColorAttribute> colors;
    private ArrayList<StringAttribute> texts;
    private ArrayList<LinkAttribute> links;
    private int jimpleStartPos;
    private int jimpleEndPos;
    private int javaStartPos;
    private int javaEndPos;
    private int javaStartLn;
    private int javaEndLn;
    private int jimpleStartLn;
    private int jimpleEndLn;

    public ArrayList<ColorAttribute> colors() {
        return this.colors;
    }

    public void addColor(ColorAttribute ca) {
        ArrayList<ColorAttribute> colors = this.colors;
        if (colors == null) {
            this.colors = colors = new ArrayList();
        }
        colors.add(ca);
    }

    public void addText(StringAttribute s2) {
        ArrayList<StringAttribute> texts = this.texts;
        if (texts == null) {
            this.texts = texts = new ArrayList();
        }
        texts.add(s2);
    }

    public void addLink(LinkAttribute la) {
        ArrayList<LinkAttribute> links = this.links;
        if (links == null) {
            this.links = links = new ArrayList();
        }
        links.add(la);
    }

    public int jimpleStartPos() {
        return this.jimpleStartPos;
    }

    public void jimpleStartPos(int x) {
        this.jimpleStartPos = x;
    }

    public int jimpleEndPos() {
        return this.jimpleEndPos;
    }

    public void jimpleEndPos(int x) {
        this.jimpleEndPos = x;
    }

    public int javaStartPos() {
        return this.javaStartPos;
    }

    public void javaStartPos(int x) {
        this.javaStartPos = x;
    }

    public int javaEndPos() {
        return this.javaEndPos;
    }

    public void javaEndPos(int x) {
        this.javaEndPos = x;
    }

    public int jimpleStartLn() {
        return this.jimpleStartLn;
    }

    public void jimpleStartLn(int x) {
        this.jimpleStartLn = x;
    }

    public int jimpleEndLn() {
        return this.jimpleEndLn;
    }

    public void jimpleEndLn(int x) {
        this.jimpleEndLn = x;
    }

    public int javaStartLn() {
        return this.javaStartLn;
    }

    public void javaStartLn(int x) {
        this.javaStartLn = x;
    }

    public int javaEndLn() {
        return this.javaEndLn;
    }

    public void javaEndLn(int x) {
        this.javaEndLn = x;
    }

    public boolean hasColor() {
        return this.colors != null;
    }

    public void addTag(Tag t2) {
        if (t2 instanceof LineNumberTag) {
            int lnNum = ((LineNumberTag)t2).getLineNumber();
            this.javaStartLn(lnNum);
            this.javaEndLn(lnNum);
        } else if (t2 instanceof JimpleLineNumberTag) {
            JimpleLineNumberTag jlnTag = (JimpleLineNumberTag)t2;
            this.jimpleStartLn(jlnTag.getStartLineNumber());
            this.jimpleEndLn(jlnTag.getEndLineNumber());
        } else if (t2 instanceof SourceLnPosTag) {
            SourceLnPosTag jlnTag = (SourceLnPosTag)t2;
            this.javaStartLn(jlnTag.startLn());
            this.javaEndLn(jlnTag.endLn());
            this.javaStartPos(jlnTag.startPos());
            this.javaEndPos(jlnTag.endPos());
        } else if (t2 instanceof LinkTag) {
            LinkTag lt = (LinkTag)t2;
            Host h2 = lt.getLink();
            this.addLink(new LinkAttribute(lt.getInfo(), this.getJimpleLnOfHost(h2), this.getJavaLnOfHost(h2), lt.getClassName(), lt.getAnalysisType()));
        } else if (t2 instanceof StringTag) {
            StringTag st = (StringTag)t2;
            this.addText(new StringAttribute(this.formatForXML(st.getInfo()), st.getAnalysisType()));
        } else if (t2 instanceof PositionTag) {
            PositionTag pt = (PositionTag)t2;
            this.jimpleStartPos(pt.getStartOffset());
            this.jimpleEndPos(pt.getEndOffset());
        } else if (t2 instanceof ColorTag) {
            ColorTag ct = (ColorTag)t2;
            this.addColor(new ColorAttribute(ct.getRed(), ct.getGreen(), ct.getBlue(), ct.isForeground(), ct.getAnalysisType()));
        } else {
            this.addText(new StringAttribute(t2.toString(), t2.getName()));
        }
    }

    private String formatForXML(String in) {
        in = in.replaceAll("<", "&lt;");
        in = in.replaceAll(">", "&gt;");
        in = in.replaceAll("&", "&amp;");
        in = in.replaceAll("\"", "&quot;");
        return in;
    }

    private int getJavaLnOfHost(Host h2) {
        for (Tag t2 : h2.getTags()) {
            if (t2 instanceof SourceLnPosTag) {
                return ((SourceLnPosTag)t2).startLn();
            }
            if (!(t2 instanceof LineNumberTag)) continue;
            return ((LineNumberTag)t2).getLineNumber();
        }
        return 0;
    }

    private int getJimpleLnOfHost(Host h2) {
        for (Tag t2 : h2.getTags()) {
            if (!(t2 instanceof JimpleLineNumberTag)) continue;
            return ((JimpleLineNumberTag)t2).getStartLineNumber();
        }
        return 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<srcPos sline=\"").append(this.javaStartLn());
        sb.append("\" eline=\"").append(this.javaEndLn());
        sb.append("\" spos=\"").append(this.javaStartPos());
        sb.append("\" epos=\"").append(this.javaEndPos()).append("\"/>");
        sb.append("<jmpPos sline=\"").append(this.jimpleStartLn());
        sb.append("\" eline=\"").append(this.jimpleEndLn());
        sb.append("\" spos=\"").append(this.jimpleStartPos());
        sb.append("\" epos=\"").append(this.jimpleEndPos()).append("\"/>");
        return sb.toString();
    }

    public boolean isEmpty() {
        return this.colors == null && this.texts == null && this.links == null;
    }

    public void print(PrintWriter writerOut) {
        if (this.isEmpty()) {
            return;
        }
        writerOut.println("<attribute>");
        writerOut.println("<srcPos sline=\"" + this.javaStartLn() + "\" eline=\"" + this.javaEndLn() + "\" spos=\"" + this.javaStartPos() + "\" epos=\"" + this.javaEndPos() + "\"/>");
        writerOut.println("<jmpPos sline=\"" + this.jimpleStartLn() + "\" eline=\"" + this.jimpleEndLn() + "\" spos=\"" + this.jimpleStartPos() + "\" epos=\"" + this.jimpleEndPos() + "\"/>");
        if (this.colors != null) {
            for (ColorAttribute ca : this.colors) {
                writerOut.println("<color r=\"" + ca.red() + "\" g=\"" + ca.green() + "\" b=\"" + ca.blue() + "\" fg=\"" + ca.fg() + "\" aType=\"" + ca.analysisType() + "\"/>");
            }
        }
        if (this.texts != null) {
            for (StringAttribute sa : this.texts) {
                writerOut.println("<text info=\"" + sa.info() + "\" aType=\"" + sa.analysisType() + "\"/>");
            }
        }
        if (this.links != null) {
            for (LinkAttribute la : this.links) {
                writerOut.println("<link label=\"" + this.formatForXML(la.info()) + "\" jmpLink=\"" + la.jimpleLink() + "\" srcLink=\"" + la.javaLink() + "\" clssNm=\"" + la.className() + "\" aType=\"" + la.analysisType() + "\"/>");
            }
        }
        writerOut.println("</attribute>");
    }
}

