/*
 * Decompiled with CFR 0.152.
 */
package soot.validation;

import java.util.List;
import soot.Body;
import soot.Local;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.toolkits.exceptions.ThrowAnalysisFactory;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.graph.ExceptionalUnitGraphFactory;
import soot.toolkits.scalar.FlowSet;
import soot.toolkits.scalar.InitAnalysis;
import soot.validation.BodyValidator;
import soot.validation.ValidationException;

public enum CheckInitValidator implements BodyValidator
{
    INSTANCE;


    public static CheckInitValidator v() {
        return INSTANCE;
    }

    @Override
    public void validate(Body body, List<ValidationException> exception) {
        ExceptionalUnitGraph g2 = ExceptionalUnitGraphFactory.createExceptionalUnitGraph(body, ThrowAnalysisFactory.checkInitThrowAnalysis(), false);
        InitAnalysis analysis = new InitAnalysis(g2);
        for (Unit s2 : body.getUnits()) {
            FlowSet init = (FlowSet)analysis.getFlowBefore(s2);
            for (ValueBox vBox : s2.getUseBoxes()) {
                Local l;
                Value v = vBox.getValue();
                if (!(v instanceof Local) || init.contains(l = (Local)v)) continue;
                exception.add(new ValidationException(s2, "Local variable " + l.getName() + " is not definitively defined at this point", "Warning: Local variable " + l + " not definitely defined at " + s2 + " in " + body.getMethod()));
            }
        }
    }

    @Override
    public boolean isBasicValidator() {
        return false;
    }
}

