/*
 * Decompiled with CFR 0.152.
 */
package soot.util.dot;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DotGraphUtility {
    private static final Logger logger = LoggerFactory.getLogger(DotGraphUtility.class);

    public static String replaceQuotes(String original) {
        byte[] ord = original.getBytes();
        int quotes = 0;
        boolean escapeActive = false;
        block4: for (byte element : ord) {
            switch (element) {
                case 92: {
                    escapeActive = true;
                    continue block4;
                }
                case 34: {
                    ++quotes;
                    if (escapeActive) {
                        ++quotes;
                    }
                }
                default: {
                    escapeActive = false;
                }
            }
        }
        if (quotes == 0) {
            return original;
        }
        byte[] newsrc = new byte[ord.length + quotes];
        int i = 0;
        int j = 0;
        int n = ord.length;
        while (i < n) {
            if (ord[i] == 34) {
                if (i > 0 && ord[i - 1] == 92) {
                    newsrc[j++] = 92;
                }
                newsrc[j++] = 92;
            }
            newsrc[j] = ord[i];
            ++i;
            ++j;
        }
        return new String(newsrc);
    }

    public static String replaceReturns(String original) {
        byte[] ord = original.getBytes();
        int quotes = 0;
        for (byte element : ord) {
            if (element != 10) continue;
            ++quotes;
        }
        if (quotes == 0) {
            return original;
        }
        byte[] newsrc = new byte[ord.length + quotes];
        int i = 0;
        int j = 0;
        int n = ord.length;
        while (i < n) {
            if (ord[i] == 10) {
                newsrc[j++] = 92;
                newsrc[j] = 110;
            } else {
                newsrc[j] = ord[i];
            }
            ++i;
            ++j;
        }
        return new String(newsrc);
    }

    public static void renderLine(OutputStream out, String content, int indent) throws IOException {
        char[] indentChars = new char[indent];
        Arrays.fill(indentChars, ' ');
        StringBuilder sb = new StringBuilder();
        sb.append(indentChars).append(content).append('\n');
        out.write(sb.toString().getBytes());
    }
}

