/*
 * Decompiled with CFR 0.152.
 */
package soot.util.dot;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import soot.util.dot.AbstractDotGraphElement;
import soot.util.dot.DotGraphAttribute;
import soot.util.dot.DotGraphUtility;
import soot.util.dot.Renderable;

public class DotGraphNode
extends AbstractDotGraphElement
implements Renderable {
    private final String name;

    public DotGraphNode(String name) {
        this.name = "\"" + DotGraphUtility.replaceQuotes(name) + "\"";
    }

    public DotGraphNode(String name, boolean dontQuoteName) {
        this.name = dontQuoteName ? DotGraphUtility.replaceQuotes(name) : "\"" + DotGraphUtility.replaceQuotes(name) + "\"";
    }

    public String getName() {
        return this.name;
    }

    public void setHTMLLabel(String label) {
        label = DotGraphUtility.replaceReturns(label);
        this.setAttribute("label", label);
    }

    public void setShape(String shape) {
        this.setAttribute("shape", shape);
    }

    public void setStyle(String style) {
        this.setAttribute("style", style);
    }

    @Override
    public void render(OutputStream out, int indent) throws IOException {
        StringBuilder line = new StringBuilder();
        line.append(this.getName());
        Collection<DotGraphAttribute> attrs = this.getAttributes();
        if (!attrs.isEmpty()) {
            line.append(" [");
            for (DotGraphAttribute attr : attrs) {
                line.append(attr.toString()).append(',');
            }
            line.append(']');
        }
        line.append(';');
        DotGraphUtility.renderLine(out, line.toString(), indent);
    }
}

