/*
 * Decompiled with CFR 0.152.
 */
package soot.util.dot;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.util.dot.AbstractDotGraphElement;
import soot.util.dot.DotGraphAttribute;
import soot.util.dot.DotGraphCommand;
import soot.util.dot.DotGraphEdge;
import soot.util.dot.DotGraphNode;
import soot.util.dot.DotGraphUtility;
import soot.util.dot.Renderable;

public class DotGraph
extends AbstractDotGraphElement
implements Renderable {
    private static final Logger logger = LoggerFactory.getLogger(DotGraph.class);
    public static final String DOT_EXTENSION = ".dot";
    private final HashMap<String, DotGraphNode> nodes;
    private final List<Renderable> drawElements;
    private final boolean isSubGraph;
    private boolean dontQuoteNodeNames;
    private String graphname;

    private DotGraph(String graphname, boolean isSubGraph) {
        this.graphname = graphname;
        this.isSubGraph = isSubGraph;
        this.nodes = new HashMap(100);
        this.drawElements = new LinkedList<Renderable>();
        this.dontQuoteNodeNames = false;
    }

    public DotGraph(String graphname) {
        this(graphname, false);
    }

    public void plot(String filename) {
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(filename));){
            this.render(out, 0);
        }
        catch (IOException ioe) {
            logger.debug(ioe.getMessage());
        }
    }

    public DotGraphEdge drawEdge(String from, String to) {
        return this.drawEdge(from, to, true);
    }

    public DotGraphEdge drawUndirectedEdge(String node1, String node2) {
        return this.drawEdge(node1, node2, false);
    }

    private DotGraphEdge drawEdge(String from, String to, boolean directed) {
        DotGraphNode src = this.drawNode(from);
        DotGraphNode dst = this.drawNode(to);
        DotGraphEdge edge = new DotGraphEdge(src, dst, directed);
        this.drawElements.add(edge);
        return edge;
    }

    public DotGraphNode drawNode(String name) {
        DotGraphNode node = this.getNode(name);
        if (node == null) {
            throw new RuntimeException("Assertion failed.");
        }
        if (!this.drawElements.contains(node)) {
            this.drawElements.add(node);
        }
        return node;
    }

    public DotGraphNode getNode(String name) {
        if (name == null) {
            return null;
        }
        DotGraphNode node = this.nodes.get(name);
        if (node == null) {
            node = new DotGraphNode(name, this.dontQuoteNodeNames);
            this.nodes.put(name, node);
        }
        return node;
    }

    public boolean containsNode(String name) {
        return name != null && this.nodes.containsKey(name);
    }

    public boolean containsNode(DotGraphNode node) {
        return this.drawElements.contains(node);
    }

    public void quoteNodeNames(boolean value) {
        this.dontQuoteNodeNames = !value;
    }

    public void setNodeShape(String shape) {
        String command = "node [shape=" + shape + "];";
        this.drawElements.add(new DotGraphCommand(command));
    }

    public void setNodeStyle(String style) {
        String command = "node [style=" + style + "];";
        this.drawElements.add(new DotGraphCommand(command));
    }

    public void setGraphSize(double width, double height) {
        String size = "\"" + width + "," + height + "\"";
        this.setAttribute("size", size);
    }

    public void setPageSize(double width, double height) {
        String size = "\"" + width + ", " + height + "\"";
        this.setAttribute("page", size);
    }

    public void setOrientation(String orientation) {
        this.setAttribute("orientation", orientation);
    }

    public void setGraphName(String name) {
        this.graphname = name;
    }

    public void setGraphLabel(String label) {
        this.setLabel(label);
    }

    public void setGraphAttribute(String id, String value) {
        this.setAttribute(id, value);
    }

    public void setGraphAttribute(DotGraphAttribute attr) {
        this.setAttribute(attr);
    }

    public DotGraph createSubGraph(String label) {
        DotGraph subgraph = new DotGraph(label, true);
        this.drawElements.add(subgraph);
        return subgraph;
    }

    @Override
    public void render(OutputStream out, int indent) throws IOException {
        if (!this.isSubGraph) {
            DotGraphUtility.renderLine(out, "digraph \"" + this.graphname + "\" {", indent);
        } else {
            DotGraphUtility.renderLine(out, "subgraph \"" + this.graphname + "\" {", indent);
        }
        for (DotGraphAttribute attr : this.getAttributes()) {
            DotGraphUtility.renderLine(out, attr.toString() + ";", indent + 4);
        }
        for (Renderable element : this.drawElements) {
            element.render(out, indent + 4);
        }
        DotGraphUtility.renderLine(out, "}", indent);
    }
}

