/*
 * Decompiled with CFR 0.152.
 */
package soot.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import soot.Body;
import soot.Unit;
import soot.toolkits.graph.UnitGraph;

public abstract class UnitMap<T>
implements Map<Unit, T> {
    private final Map<Unit, T> unitToResult;

    public UnitMap(Body b) {
        this.unitToResult = new HashMap<Unit, T>();
        this.map(b);
    }

    public UnitMap(UnitGraph g2) {
        this(g2.getBody());
    }

    public UnitMap(Body b, int initialCapacity) {
        this.unitToResult = new HashMap<Unit, T>(initialCapacity);
        this.map(b);
    }

    public UnitMap(UnitGraph g2, int initialCapacity) {
        this(g2.getBody(), initialCapacity);
    }

    public UnitMap(Body b, int initialCapacity, float loadFactor) {
        this.unitToResult = new HashMap<Unit, T>(initialCapacity);
        this.init();
        this.map(b);
    }

    public UnitMap(UnitGraph g2, int initialCapacity, float loadFactor) {
        this(g2.getBody(), initialCapacity);
    }

    private void map(Body b) {
        for (Unit currentUnit : b.getUnits()) {
            T o = this.mapTo(currentUnit);
            if (o == null) continue;
            this.unitToResult.put(currentUnit, o);
        }
    }

    protected void init() {
    }

    protected abstract T mapTo(Unit var1);

    @Override
    public void clear() {
        this.unitToResult.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.unitToResult.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.unitToResult.containsValue(value);
    }

    @Override
    public Set<Map.Entry<Unit, T>> entrySet() {
        return this.unitToResult.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.unitToResult.equals(o);
    }

    @Override
    public T get(Object key) {
        return this.unitToResult.get(key);
    }

    @Override
    public int hashCode() {
        return this.unitToResult.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.unitToResult.isEmpty();
    }

    @Override
    public Set<Unit> keySet() {
        return this.unitToResult.keySet();
    }

    @Override
    public T put(Unit key, T value) {
        return this.unitToResult.put(key, value);
    }

    @Override
    public void putAll(Map<? extends Unit, ? extends T> t2) {
        this.unitToResult.putAll(t2);
    }

    @Override
    public T remove(Object key) {
        return this.unitToResult.remove(key);
    }

    @Override
    public int size() {
        return this.unitToResult.size();
    }

    @Override
    public Collection<T> values() {
        return this.unitToResult.values();
    }
}

