/*
 * Decompiled with CFR 0.152.
 */
package soot.util;

import java.text.StringCharacterIterator;

public class StringTools {
    public static final String lineSeparator = System.getProperty("line.separator");

    public static String getEscapedStringOf(String fromString) {
        StringBuilder whole = new StringBuilder();
        assert (!lineSeparator.isEmpty());
        char cr = lineSeparator.charAt(0);
        char lf = lineSeparator.length() == 2 ? (char)lineSeparator.charAt(1) : (char)'\uffffffff';
        for (char ch : fromString.toCharArray()) {
            char asInt = ch;
            if (asInt != '\\' && (asInt >= ' ' && asInt <= '~' || asInt == cr || asInt == lf)) {
                whole.append(ch);
                continue;
            }
            whole.append(StringTools.getUnicodeStringFromChar(ch));
        }
        return whole.toString();
    }

    public static String getQuotedStringOf(String fromString) {
        int fromStringLen = fromString.length();
        StringBuilder toStringBuffer = new StringBuilder(fromStringLen + 20);
        toStringBuffer.append("\"");
        block9: for (int i = 0; i < fromStringLen; ++i) {
            char ch = fromString.charAt(i);
            switch (ch) {
                case '\\': {
                    toStringBuffer.append("\\\\");
                    continue block9;
                }
                case '\'': {
                    toStringBuffer.append("\\'");
                    continue block9;
                }
                case '\"': {
                    toStringBuffer.append("\\\"");
                    continue block9;
                }
                case '\n': {
                    toStringBuffer.append("\\n");
                    continue block9;
                }
                case '\t': {
                    toStringBuffer.append("\\t");
                    continue block9;
                }
                case '\r': {
                    toStringBuffer.append("\\r");
                    continue block9;
                }
                case '\f': {
                    toStringBuffer.append("\\f");
                    continue block9;
                }
                default: {
                    if (ch >= ' ' && ch <= '~') {
                        toStringBuffer.append(ch);
                        continue block9;
                    }
                    toStringBuffer.append(StringTools.getUnicodeStringFromChar(ch));
                }
            }
        }
        toStringBuffer.append("\"");
        return toStringBuffer.toString();
    }

    public static String getUnicodeStringFromChar(char ch) {
        String s2 = Integer.toHexString(ch);
        switch (s2.length()) {
            case 1: {
                return "\\u000" + s2;
            }
            case 2: {
                return "\\u00" + s2;
            }
            case 3: {
                return "\\u0" + s2;
            }
            case 4: {
                return "\\u" + s2;
            }
        }
        throw new AssertionError((Object)("invalid hex string '" + s2 + "' from char '" + ch + "'"));
    }

    public static String getUnEscapedStringOf(String str) {
        StringBuilder buf = new StringBuilder();
        StringCharacterIterator iter = new StringCharacterIterator(str);
        char ch = iter.first();
        while (ch != '\uffff') {
            if (ch != '\\') {
                buf.append(ch);
            } else {
                ch = iter.next();
                if (ch == '\\') {
                    buf.append(ch);
                } else {
                    char format = StringTools.getCFormatChar(ch);
                    if (format != '\u0000') {
                        buf.append(format);
                    } else if (ch == 'u') {
                        StringBuilder mini = new StringBuilder(4);
                        for (int i = 0; i < 4; ++i) {
                            mini.append(iter.next());
                        }
                        buf.append((char)Integer.parseInt(mini.toString(), 16));
                    } else {
                        throw new RuntimeException("Unexpected char: " + ch);
                    }
                }
            }
            ch = iter.next();
        }
        return buf.toString();
    }

    public static char getCFormatChar(char c) {
        switch (c) {
            case 'n': {
                return '\n';
            }
            case 't': {
                return '\t';
            }
            case 'r': {
                return '\r';
            }
            case 'b': {
                return '\b';
            }
            case 'f': {
                return '\f';
            }
            case '\"': {
                return '\"';
            }
            case '\'': {
                return '\'';
            }
        }
        return '\u0000';
    }
}

