/*
 * Decompiled with CFR 0.152.
 */
package soot.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public final class SharedCloseable<T extends Closeable>
implements AutoCloseable {
    private static final AtomicLongFieldUpdater<SharedCloseable> NUM_REFS_UPDATER = AtomicLongFieldUpdater.newUpdater(SharedCloseable.class, "numRefs");
    private volatile long numRefs = 1L;
    private final T resource;

    public SharedCloseable(T resource) {
        this.resource = resource;
    }

    public SharedCloseable<T> acquire() {
        long oldCount = NUM_REFS_UPDATER.getAndIncrement(this);
        if (oldCount <= 0L) {
            NUM_REFS_UPDATER.getAndDecrement(this);
            throw new IllegalStateException("Already closed");
        }
        return this;
    }

    public boolean release() {
        long newCount = NUM_REFS_UPDATER.decrementAndGet(this);
        if (newCount == 0L) {
            try {
                this.resource.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return true;
        }
        if (newCount < 0L) {
            throw new IllegalStateException("Already closed");
        }
        return false;
    }

    public T get() {
        return this.resource;
    }

    @Override
    public void close() {
        this.release();
    }
}

