/*
 * Decompiled with CFR 0.152.
 */
package soot.util;

import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.util.PriorityQueue;

class LargePriorityQueue<E>
extends PriorityQueue<E> {
    private final BitSet queue = new BitSet(this.N);
    private long modCount = 0L;

    LargePriorityQueue(List<? extends E> universe, Map<E, Integer> ordinalMap) {
        super(universe, ordinalMap);
    }

    @Override
    boolean add(int ordinal) {
        if (this.contains(ordinal)) {
            return false;
        }
        this.queue.set(ordinal);
        this.min = Math.min(this.min, ordinal);
        ++this.modCount;
        return true;
    }

    @Override
    void addAll() {
        this.queue.set(0, this.N);
        this.min = 0;
        ++this.modCount;
    }

    @Override
    int nextSetBit(int fromIndex) {
        int i = this.queue.nextSetBit(fromIndex);
        return i < 0 ? Integer.MAX_VALUE : i;
    }

    @Override
    boolean remove(int ordinal) {
        if (!this.contains(ordinal)) {
            return false;
        }
        this.queue.clear(ordinal);
        if (this.min == ordinal) {
            this.min = this.nextSetBit(this.min + 1);
        }
        ++this.modCount;
        return true;
    }

    @Override
    boolean contains(int ordinal) {
        return this.queue.get(ordinal);
    }

    @Override
    public Iterator<E> iterator() {
        return new PriorityQueue.Itr(){

            @Override
            long getExpected() {
                return LargePriorityQueue.this.modCount;
            }
        };
    }

    @Override
    public int size() {
        return this.queue.cardinality();
    }
}

