/*
 * Decompiled with CFR 0.152.
 */
package soot.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import soot.util.INumberedMap;
import soot.util.IterableNumberer;
import soot.util.Numberable;

public final class LargeNumberedMap<K extends Numberable, V>
implements INumberedMap<K, V> {
    private final IterableNumberer<K> universe;
    private V[] values;

    public LargeNumberedMap(IterableNumberer<K> universe) {
        this.universe = universe;
        int size = universe.size();
        this.values = LargeNumberedMap.newArray(size < 8 ? 8 : size);
    }

    private static <T> T[] newArray(int size) {
        return new Object[size];
    }

    @Override
    public boolean put(K key, V value) {
        int number = key.getNumber();
        if (number == 0) {
            throw new RuntimeException(String.format("oops, forgot to initialize. Object is of type %s, and looks like this: %s", key.getClass().getName(), key.toString()));
        }
        if (number >= this.values.length) {
            V[] oldValues = this.values;
            this.values = LargeNumberedMap.newArray(Math.max(this.universe.size() * 2, number) + 5);
            System.arraycopy(oldValues, 0, this.values, 0, oldValues.length);
        }
        boolean ret = this.values[number] != value;
        this.values[number] = value;
        return ret;
    }

    @Override
    public V get(K key) {
        int i = key.getNumber();
        if (i >= this.values.length) {
            return null;
        }
        return this.values[i];
    }

    @Override
    public void remove(K key) {
        int i = key.getNumber();
        if (i < this.values.length) {
            this.values[i] = null;
        }
    }

    @Override
    public Iterator<K> keyIterator() {
        return new Iterator<K>(){
            int cur = 0;

            private void advance() {
                while (this.cur < LargeNumberedMap.this.values.length && LargeNumberedMap.this.values[this.cur] == null) {
                    ++this.cur;
                }
            }

            @Override
            public boolean hasNext() {
                this.advance();
                return this.cur < LargeNumberedMap.this.values.length;
            }

            @Override
            public K next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return (Numberable)LargeNumberedMap.this.universe.get(this.cur++);
            }

            @Override
            public void remove() {
                LargeNumberedMap.this.values[this.cur - 1] = null;
            }
        };
    }
}

