/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.Local;
import soot.Scene;
import soot.Singletons;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.Value;
import soot.ValueBox;
import soot.dexpler.DexNullArrayRefTransformer;
import soot.dexpler.DexNullThrowTransformer;
import soot.jimple.AssignStmt;
import soot.jimple.Constant;
import soot.jimple.Jimple;
import soot.jimple.toolkits.scalar.ConstantPropagatorAndFolder;
import soot.jimple.toolkits.scalar.CopyPropagator;
import soot.jimple.toolkits.scalar.DeadAssignmentEliminator;
import soot.options.Options;
import soot.toolkits.exceptions.ThrowAnalysis;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.graph.ExceptionalUnitGraphFactory;
import soot.toolkits.scalar.FlowSensitiveConstantPropagator;
import soot.toolkits.scalar.LocalDefs;
import soot.util.Chain;
import soot.util.HashMultiMap;

public class SharedInitializationLocalSplitter
extends BodyTransformer {
    private static final Logger logger = LoggerFactory.getLogger(SharedInitializationLocalSplitter.class);
    protected ThrowAnalysis throwAnalysis;
    protected boolean omitExceptingUnitEdges;

    public SharedInitializationLocalSplitter(Singletons.Global g2) {
    }

    public SharedInitializationLocalSplitter(ThrowAnalysis ta) {
        this(ta, false);
    }

    public SharedInitializationLocalSplitter(ThrowAnalysis ta, boolean omitExceptingUnitEdges) {
        this.throwAnalysis = ta;
        this.omitExceptingUnitEdges = omitExceptingUnitEdges;
    }

    public static SharedInitializationLocalSplitter v() {
        return G.v().soot_toolkits_scalar_SharedInitializationLocalSplitter();
    }

    @Override
    protected void internalTransform(Body body, String phaseName, Map<String, String> options) {
        if (Options.v().verbose()) {
            logger.debug("[" + body.getMethod().getName() + "] Splitting for shared initialization of locals...");
        }
        if (this.throwAnalysis == null) {
            this.throwAnalysis = Scene.v().getDefaultThrowAnalysis();
        }
        if (!this.omitExceptingUnitEdges) {
            this.omitExceptingUnitEdges = Options.v().omit_excepting_unit_edges();
        }
        CopyPropagator.v().transform(body);
        ConstantPropagatorAndFolder.v().transform(body);
        DexNullThrowTransformer.v().transform(body);
        DexNullArrayRefTransformer.v().transform(body);
        FlowSensitiveConstantPropagator.v().transform(body);
        CopyPropagator.v().transform(body);
        DexNullThrowTransformer.v().transform(body);
        DexNullArrayRefTransformer.v().transform(body);
        DeadAssignmentEliminator.v().transform(body);
        CopyPropagator.v().transform(body);
        ExceptionalUnitGraph graph = ExceptionalUnitGraphFactory.createExceptionalUnitGraph(body, this.throwAnalysis, this.omitExceptingUnitEdges);
        LocalDefs defs = G.v().soot_toolkits_scalar_LocalDefsFactory().newLocalDefs(graph, true);
        HashMultiMap<Local, Cluster> clustersPerLocal = new HashMultiMap<Local, Cluster>();
        UnitPatchingChain units = body.getUnits();
        for (Unit s2 : units) {
            for (ValueBox useBox : s2.getUseBoxes()) {
                Local luse;
                List<Unit> allAffectingDefs;
                Value v = useBox.getValue();
                if (!(v instanceof Local) || (allAffectingDefs = defs.getDefsOfAt(luse = (Local)v, s2)).isEmpty() || !allAffectingDefs.stream().allMatch(u -> u instanceof AssignStmt && ((AssignStmt)u).getRightOp() instanceof Constant)) continue;
                clustersPerLocal.put(luse, new Cluster(s2, allAffectingDefs));
            }
        }
        Chain<Local> locals = body.getLocals();
        int w = 0;
        for (Local lcl : clustersPerLocal.keySet()) {
            Set clusters = clustersPerLocal.get(lcl);
            if (clusters.size() <= 1) continue;
            for (Cluster cluster : clusters) {
                Local newLocal = (Local)lcl.clone();
                newLocal.setName(newLocal.getName() + "_" + ++w);
                locals.add(newLocal);
                for (Unit u2 : cluster.constantInitializers) {
                    AssignStmt assign = (AssignStmt)u2;
                    AssignStmt newAssign = Jimple.v().newAssignStmt(newLocal, assign.getRightOp());
                    units.insertAfter(newAssign, assign);
                    CopyPropagator.copyLineTags(newAssign.getUseBoxes().get(0), assign);
                }
                this.replaceLocalsInUnitUses(cluster.use, lcl, newLocal);
            }
        }
    }

    private void replaceLocalsInUnitUses(Unit change, Value oldLocal, Local newLocal) {
        for (ValueBox u : change.getUseBoxes()) {
            if (u.getValue() != oldLocal) continue;
            u.setValue(newLocal);
        }
    }

    private static final class Cluster {
        protected final List<Unit> constantInitializers;
        protected final Unit use;

        public Cluster(Unit use, List<Unit> constantInitializers) {
            this.use = use;
            this.constantInitializers = constantInitializers;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Constant intializers:\n");
            for (Unit r : this.constantInitializers) {
                sb.append("\n - ").append(this.toStringUnit(r));
            }
            return sb.toString();
        }

        private String toStringUnit(Unit u) {
            return u + " (" + System.identityHashCode(u) + ")";
        }
    }
}

