/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.IdentityUnit;
import soot.Local;
import soot.PhaseOptions;
import soot.Singletons;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.GroupIntPair;
import soot.options.Options;
import soot.toolkits.scalar.FastColorer;
import soot.util.Chain;
import soot.util.DeterministicHashMap;

public class LocalPacker
extends BodyTransformer {
    private static final Logger logger = LoggerFactory.getLogger(LocalPacker.class);

    public LocalPacker(Singletons.Global g2) {
    }

    public static LocalPacker v() {
        return G.v().soot_toolkits_scalar_LocalPacker();
    }

    @Override
    protected void internalTransform(Body body, String phaseName, Map<String, String> options) {
        Chain<Local> bodyLocalsRef;
        int origLocalCount;
        if (Options.v().verbose()) {
            logger.debug("[" + body.getMethod().getName() + "] Packing locals...");
        }
        if ((origLocalCount = (bodyLocalsRef = body.getLocals()).size()) < 1) {
            return;
        }
        DeterministicHashMap<Local, Type> localToGroup = new DeterministicHashMap<Local, Type>(origLocalCount * 2 + 1, 0.7f);
        HashMap<Type, Integer> groupToColorCount = new HashMap<Type, Integer>(origLocalCount * 2 + 1, 0.7f);
        HashMap<Local, Integer> localToColor = new HashMap<Local, Integer>(origLocalCount * 2 + 1, 0.7f);
        for (Local l : bodyLocalsRef) {
            Type g2 = l.getType();
            localToGroup.put(l, g2);
            groupToColorCount.putIfAbsent(g2, 0);
        }
        for (Unit s2 : body.getUnits()) {
            Value leftOp;
            if (!(s2 instanceof IdentityUnit) || !((leftOp = ((IdentityUnit)s2).getLeftOp()) instanceof Local)) continue;
            Local l = (Local)leftOp;
            Type group = (Type)localToGroup.get(l);
            Integer count = (Integer)groupToColorCount.get(group);
            localToColor.put(l, count);
            groupToColorCount.put(group, count + 1);
        }
        if (PhaseOptions.getBoolean(options, "unsplit-original-locals")) {
            FastColorer.unsplitAssignColorsToLocals(body, localToGroup, localToColor, groupToColorCount);
        } else {
            FastColorer.assignColorsToLocals(body, localToGroup, localToColor, groupToColorCount);
        }
        HashMap<Local, Local> localToNewLocal = new HashMap<Local, Local>(origLocalCount * 2 + 1, 0.7f);
        HashMap<GroupIntPair, Local> groupIntToLocal = new HashMap<GroupIntPair, Local>(origLocalCount * 2 + 1, 0.7f);
        ArrayList<Local> originalLocals = new ArrayList<Local>(bodyLocalsRef);
        bodyLocalsRef.clear();
        HashSet<String> usedLocalNames = new HashSet<String>();
        for (Local original : originalLocals) {
            Type group = (Type)localToGroup.get(original);
            GroupIntPair pair = new GroupIntPair(group, (Integer)localToColor.get(original));
            Local newLocal = (Local)groupIntToLocal.get(pair);
            if (newLocal == null) {
                newLocal = (Local)original.clone();
                newLocal.setType(group);
                String name = newLocal.getName();
                if (name != null) {
                    int signIndex = name.indexOf(35);
                    if (signIndex >= 0) {
                        String newName = name.substring(0, signIndex);
                        if (usedLocalNames.add(newName)) {
                            newLocal.setName(newName);
                        }
                    } else {
                        usedLocalNames.add(name);
                    }
                }
                groupIntToLocal.put(pair, newLocal);
                bodyLocalsRef.add(newLocal);
            }
            localToNewLocal.put(original, newLocal);
        }
        for (Unit s3 : body.getUnits()) {
            Value val;
            for (ValueBox box : s3.getUseBoxes()) {
                val = box.getValue();
                if (!(val instanceof Local)) continue;
                box.setValue((Value)localToNewLocal.get((Local)val));
            }
            for (ValueBox box : s3.getDefBoxes()) {
                val = box.getValue();
                if (!(val instanceof Local)) continue;
                box.setValue((Value)localToNewLocal.get((Local)val));
            }
        }
    }
}

