/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import soot.toolkits.scalar.AbstractFlowSet;
import soot.toolkits.scalar.FlowSet;

public class HashSparseSet<T>
extends AbstractFlowSet<T> {
    protected LinkedHashSet<T> elements;

    public HashSparseSet() {
        LinkedHashSet newElements = new LinkedHashSet();
        this.elements = newElements;
    }

    private HashSparseSet(HashSparseSet<T> other) {
        this.elements = new LinkedHashSet<T>(other.elements);
    }

    private boolean sameType(Object flowSet) {
        return flowSet instanceof HashSparseSet;
    }

    @Override
    public HashSparseSet<T> clone() {
        return new HashSparseSet<T>(this);
    }

    @Override
    public FlowSet<T> emptySet() {
        return new HashSparseSet<T>();
    }

    @Override
    public void clear() {
        this.elements.clear();
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    @Override
    public List<T> toList() {
        return new ArrayList<T>(this.elements);
    }

    @Override
    public void add(T e) {
        this.elements.add(e);
    }

    @Override
    public void remove(Object obj) {
        this.elements.remove(obj);
    }

    @Override
    public void remove(int idx) {
        Iterator itr = this.elements.iterator();
        int currentIndex = 0;
        Object elem = null;
        while (itr.hasNext()) {
            elem = itr.next();
            if (currentIndex == idx) break;
            ++currentIndex;
        }
        if (elem != null) {
            this.elements.remove(elem);
        }
    }

    @Override
    public void union(FlowSet<T> otherFlow, FlowSet<T> destFlow) {
        if (this.sameType(otherFlow) && this.sameType(destFlow)) {
            HashSparseSet other = (HashSparseSet)otherFlow;
            HashSparseSet dest = (HashSparseSet)destFlow;
            dest.elements.addAll(this.elements);
            dest.elements.addAll(other.elements);
        } else {
            super.union(otherFlow, destFlow);
        }
    }

    @Override
    public void intersection(FlowSet<T> otherFlow, FlowSet<T> destFlow) {
        if (this.sameType(otherFlow) && this.sameType(destFlow)) {
            HashSparseSet other = (HashSparseSet)otherFlow;
            HashSparseSet dest = (HashSparseSet)destFlow;
            HashSparseSet<T> workingSet = new HashSparseSet<T>(this);
            workingSet.elements.retainAll(other.elements);
            dest.elements = workingSet.elements;
        } else {
            super.intersection(otherFlow, destFlow);
        }
    }

    @Override
    public void difference(FlowSet<T> otherFlow, FlowSet<T> destFlow) {
        if (this.sameType(otherFlow) && this.sameType(destFlow)) {
            HashSparseSet workingSet;
            HashSparseSet dest = (HashSparseSet)destFlow;
            HashSparseSet other = (HashSparseSet)otherFlow;
            if (dest == other || dest == this) {
                workingSet = new HashSparseSet();
            } else {
                workingSet = dest;
                workingSet.clear();
            }
            for (Object elem : this.elements) {
                if (other.elements.contains(elem)) continue;
                workingSet.elements.add(elem);
            }
            if (workingSet != dest) {
                workingSet.copy(dest);
            }
        } else {
            super.difference(otherFlow, destFlow);
        }
    }

    @Override
    public boolean contains(Object obj) {
        return this.elements.contains(obj);
    }

    @Override
    public boolean equals(Object otherFlow) {
        if (this.sameType(otherFlow)) {
            HashSparseSet other = (HashSparseSet)otherFlow;
            return this.elements.equals(other.elements);
        }
        return super.equals(otherFlow);
    }

    @Override
    public void copy(FlowSet<T> destFlow) {
        if (this.sameType(destFlow)) {
            HashSparseSet dest = (HashSparseSet)destFlow;
            dest.elements.clear();
            dest.elements.addAll(this.elements);
        } else {
            super.copy(destFlow);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return this.elements.iterator();
    }
}

