/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.graph.pdg;

import java.util.ArrayList;
import java.util.List;
import soot.toolkits.graph.Block;
import soot.toolkits.graph.pdg.IRegion;

public class PDGNode {
    protected Type m_type;
    protected Object m_node = null;
    protected List<PDGNode> m_dependents = new ArrayList<PDGNode>();
    protected List<PDGNode> m_backDependents = new ArrayList<PDGNode>();
    protected PDGNode m_next = null;
    protected PDGNode m_prev = null;
    protected Attribute m_attrib = Attribute.NORMAL;
    protected boolean m_visited = false;

    public PDGNode(Object obj, Type t2) {
        this.m_node = obj;
        this.m_type = t2;
    }

    public Type getType() {
        return this.m_type;
    }

    public void setType(Type t2) {
        this.m_type = t2;
    }

    public Object getNode() {
        return this.m_node;
    }

    public void setNext(PDGNode n) {
        this.m_next = n;
    }

    public PDGNode getNext() {
        return this.m_next;
    }

    public void setPrev(PDGNode n) {
        this.m_prev = n;
    }

    public PDGNode getPrev() {
        return this.m_prev;
    }

    public void setVisited(boolean v) {
        this.m_visited = v;
    }

    public boolean getVisited() {
        return this.m_visited;
    }

    public void setNode(Object obj) {
        this.m_node = obj;
    }

    public Attribute getAttrib() {
        return this.m_attrib;
    }

    public void setAttrib(Attribute a) {
        this.m_attrib = a;
    }

    public void addDependent(PDGNode node) {
        if (!this.m_dependents.contains(node)) {
            this.m_dependents.add(node);
        }
    }

    public void addBackDependent(PDGNode node) {
        this.m_backDependents.add(node);
    }

    public void removeDependent(PDGNode node) {
        this.m_dependents.remove(node);
    }

    public List<PDGNode> getDependents() {
        return this.m_dependents;
    }

    public List<PDGNode> getBackDependets() {
        return this.m_backDependents;
    }

    public String toString() {
        Object s2 = new String();
        s2 = "Type: " + (this.m_type == Type.REGION ? "REGION: " : "CFGNODE: ");
        s2 = (String)s2 + this.m_node;
        return s2;
    }

    public String toShortString() {
        Object s2 = new String();
        s2 = "Type: " + (this.m_type == Type.REGION ? "REGION: " : "CFGNODE: ");
        s2 = this.m_type == Type.REGION ? (String)s2 + ((IRegion)this.m_node).getID() : (String)s2 + ((Block)this.m_node).toShortString();
        return s2;
    }

    public static enum Attribute {
        NORMAL,
        ENTRY,
        CONDHEADER,
        LOOPHEADER;

    }

    public static enum Type {
        REGION,
        CFGNODE;

    }
}

