/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.exceptions;

import java.util.Set;
import java.util.stream.Collectors;
import soot.AnySubType;
import soot.Local;
import soot.NullType;
import soot.RefType;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.UnknownType;
import soot.Value;
import soot.baf.ThrowInst;
import soot.grimp.NewInvokeExpr;
import soot.jimple.DefinitionStmt;
import soot.jimple.NewExpr;
import soot.jimple.ThrowStmt;
import soot.toolkits.exceptions.ThrowAnalysis;
import soot.toolkits.exceptions.ThrowableSet;

public abstract class AbstractThrowAnalysis
implements ThrowAnalysis {
    @Override
    public abstract ThrowableSet mightThrow(Unit var1);

    @Override
    public ThrowableSet mightThrowExplicitly(ThrowInst t2) {
        return ThrowableSet.Manager.v().ALL_THROWABLES;
    }

    @Override
    public ThrowableSet mightThrowExplicitly(ThrowStmt t2) {
        return this.mightThrowExplicitly(t2, null);
    }

    public ThrowableSet mightThrowExplicitly(ThrowStmt t2, SootMethod sm) {
        Value thrownExpression = t2.getOp();
        Type thrownType = thrownExpression.getType();
        if (thrownType == null || thrownType instanceof UnknownType) {
            return ThrowableSet.Manager.v().ALL_THROWABLES;
        }
        if (thrownType instanceof NullType) {
            ThrowableSet result = ThrowableSet.Manager.v().EMPTY;
            result = result.add(ThrowableSet.Manager.v().NULL_POINTER_EXCEPTION);
            return result;
        }
        if (!(thrownType instanceof RefType)) {
            throw new IllegalStateException("UnitThrowAnalysis StmtSwitch: type of throw argument is not a RefType!");
        }
        ThrowableSet result = ThrowableSet.Manager.v().EMPTY;
        if (thrownExpression instanceof NewInvokeExpr) {
            result = result.add((RefType)thrownType);
        } else {
            Set types;
            RefType preciseType = null;
            if (thrownExpression instanceof Local && sm != null && (types = sm.getActiveBody().getUnits().stream().filter(u -> u instanceof DefinitionStmt).map(u -> (DefinitionStmt)u).filter(d -> d.getLeftOp() == thrownExpression).map(d -> d.getRightOp()).filter(o -> o instanceof NewExpr).map(o -> (NewExpr)o).map(n -> n.getType()).filter(r -> r instanceof RefType).map(r -> (RefType)r).collect(Collectors.toSet())).size() == 1) {
                preciseType = (RefType)types.iterator().next();
            }
            result = preciseType == null ? result.add(AnySubType.v((RefType)thrownType)) : result.add(preciseType);
        }
        return result;
    }

    @Override
    public abstract ThrowableSet mightThrowImplicitly(ThrowInst var1);

    @Override
    public abstract ThrowableSet mightThrowImplicitly(ThrowStmt var1);
}

