/*
 * Decompiled with CFR 0.152.
 */
package soot.toDex;

import java.util.Iterator;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.Singletons;
import soot.Trap;
import soot.Unit;
import soot.jimple.IdentityStmt;
import soot.jimple.ParameterRef;
import soot.jimple.ThisRef;

public class FastDexTrapTightener
extends BodyTransformer {
    public FastDexTrapTightener(Singletons.Global g2) {
    }

    public static FastDexTrapTightener v() {
        return G.v().soot_toDex_FastDexTrapTightener();
    }

    @Override
    protected void internalTransform(Body b, String phaseName, Map<String, String> options) {
        Iterator<Trap> trapIt = b.getTraps().snapshotIterator();
        while (trapIt.hasNext()) {
            Unit beginUnit;
            Trap t2 = trapIt.next();
            while (!this.isDexInstruction(beginUnit = t2.getBeginUnit()) && t2.getBeginUnit() != t2.getEndUnit()) {
                t2.setBeginUnit(b.getUnits().getSuccOf(beginUnit));
            }
            if (t2.getBeginUnit() != t2.getEndUnit()) continue;
            trapIt.remove();
        }
    }

    private boolean isDexInstruction(Unit unit) {
        if (unit instanceof IdentityStmt) {
            IdentityStmt is = (IdentityStmt)unit;
            return !(is.getRightOp() instanceof ThisRef) && !(is.getRightOp() instanceof ParameterRef);
        }
        return true;
    }
}

