/*
 * Decompiled with CFR 0.152.
 */
package soot.sootify;

import java.io.PrintWriter;
import soot.Body;
import soot.G;
import soot.Local;
import soot.Singletons;
import soot.SootClass;
import soot.SootMethod;
import soot.Unit;
import soot.sootify.StmtTemplatePrinter;

public class TemplatePrinter {
    private PrintWriter out;
    private int indentationLevel = 0;

    public TemplatePrinter(Singletons.Global g2) {
    }

    public static TemplatePrinter v() {
        return G.v().soot_sootify_TemplatePrinter();
    }

    public void printTo(SootClass c, PrintWriter out) {
        this.out = out;
        this.printTo(c);
    }

    private void printTo(SootClass c) {
        int i;
        this.println("import java.util.*;");
        this.println("import soot.*;");
        this.println("import soot.jimple.*;");
        this.println("import soot.util.*;");
        this.println("");
        this.print("public class ");
        this.print(c.getName().replace('.', '_') + "_Maker");
        this.println(" {");
        this.println("private static Local localByName(Body b, String name) {");
        this.println("\tfor(Local l: b.getLocals()) {");
        this.println("\t\tif(l.getName().equals(name))");
        this.println("\t\t\treturn l;");
        this.println("\t}");
        this.println("\tthrow new IllegalArgumentException(\"No such local: \"+name);");
        this.println("}");
        this.indent();
        this.println("public void create() {");
        this.indent();
        this.println("SootClass c = new SootClass(\"" + c.getName() + "\");");
        this.println("c.setApplicationClass();");
        this.println("Scene.v().addClass(c);");
        for (i = 0; i < c.getMethodCount(); ++i) {
            this.println("createMethod" + i + "(c);");
        }
        this.closeMethod();
        i = 0;
        for (SootMethod m4 : c.getMethods()) {
            this.newMethod("createMethod" + i);
            this.println("SootMethod m = new SootMethod(\"" + m4.getName() + "\",null,null);");
            this.println("Body b = Jimple.v().newBody(m);");
            this.println("m.setActiveBody(b);");
            if (!m4.hasActiveBody()) continue;
            Body b = m4.getActiveBody();
            this.println("Chain<Local> locals = b.getLocals();");
            for (Local l : b.getLocals()) {
                this.println("locals.add(Jimple.v().newLocal(\"" + l.getName() + "\", RefType.v(\"" + l.getType() + "\")));");
            }
            this.println("Chain<Unit> units = b.getUnits();");
            StmtTemplatePrinter sw = new StmtTemplatePrinter(this, b.getUnits());
            for (Unit u : b.getUnits()) {
                u.apply(sw);
            }
            this.closeMethod();
            ++i;
        }
        this.println("}");
    }

    private void closeMethod() {
        this.unindent();
        this.println("}");
        this.unindent();
        this.println("");
    }

    private void newMethod(String name) {
        this.indent();
        this.println("public void " + name + "(SootClass c) {");
        this.indent();
    }

    public void printlnNoIndent(String s2) {
        this.printNoIndent(s2);
        this.print("\n");
    }

    public void println(String s2) {
        this.print(s2);
        this.print("\n");
    }

    public void printNoIndent(String s2) {
        this.out.print(s2);
    }

    public void print(String s2) {
        for (int i = 0; i < this.indentationLevel; ++i) {
            this.out.print("  ");
        }
        this.out.print(s2);
    }

    public void indent() {
        ++this.indentationLevel;
    }

    public void unindent() {
        --this.indentationLevel;
    }

    public void openBlock() {
        this.println("{");
        this.indent();
    }

    public void closeBlock() {
        this.unindent();
        this.println("}");
    }
}

