/*
 * Decompiled with CFR 0.152.
 */
package soot.shimple;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.StmtBody;
import soot.options.Options;
import soot.options.ShimpleOptions;
import soot.shimple.Shimple;
import soot.shimple.internal.SPatchingChain;
import soot.shimple.internal.ShimpleBodyBuilder;
import soot.util.HashChain;

public class ShimpleBody
extends StmtBody {
    private static final Logger logger = LoggerFactory.getLogger(ShimpleBody.class);
    protected ShimpleOptions options;
    protected ShimpleBodyBuilder sbb;
    protected boolean isSSA = false;

    ShimpleBody(SootMethod m4, Map<String, String> options) {
        super(m4);
        this.options = new ShimpleOptions(options);
        this.setSSA(true);
        this.unitChain = new SPatchingChain(this, new HashChain<Unit>());
        this.sbb = new ShimpleBodyBuilder(this);
    }

    ShimpleBody(Body body, Map<String, String> options) {
        super(body.getMethod());
        if (!(body instanceof JimpleBody) && !(body instanceof ShimpleBody)) {
            throw new RuntimeException("Cannot construct ShimpleBody from given Body type: " + body.getClass());
        }
        if (Options.v().verbose()) {
            logger.debug("[" + this.getMethod().getName() + "] Constructing ShimpleBody...");
        }
        this.options = new ShimpleOptions(options);
        this.unitChain = new SPatchingChain(this, new HashChain<Unit>());
        this.importBodyContentsFrom(body);
        this.sbb = new ShimpleBodyBuilder(this);
        this.rebuild(body instanceof ShimpleBody);
    }

    public void rebuild() {
        this.rebuild(true);
    }

    public void rebuild(boolean hasPhiNodes) {
        this.sbb.transform();
        this.setSSA(true);
    }

    public JimpleBody toJimpleBody() {
        ShimpleBody sBody = (ShimpleBody)this.clone();
        sBody.eliminateNodes();
        JimpleBody jBody = Jimple.v().newBody(sBody.getMethod());
        jBody.importBodyContentsFrom(sBody);
        return jBody;
    }

    public void eliminatePhiNodes() {
        this.sbb.preElimOpt();
        this.sbb.eliminatePhiNodes();
        this.sbb.postElimOpt();
        this.setSSA(false);
    }

    public void eliminatePiNodes() {
        this.sbb.eliminatePiNodes();
    }

    public void eliminateNodes() {
        this.sbb.preElimOpt();
        this.sbb.eliminatePhiNodes();
        if (this.options.extended()) {
            this.sbb.eliminatePiNodes();
        }
        this.sbb.postElimOpt();
        this.setSSA(false);
    }

    @Override
    public Object clone() {
        ShimpleBody b = Shimple.v().newBody(this.getMethodUnsafe());
        b.importBodyContentsFrom(this);
        return b;
    }

    @Override
    public Object clone(boolean noLocalsClone) {
        ShimpleBody b = Shimple.v().newBody(this.getMethod());
        b.importBodyContentsFrom(this, true);
        return b;
    }

    public void setSSA(boolean isSSA) {
        this.isSSA = isSSA;
    }

    public boolean isSSA() {
        return this.isSSA;
    }

    public boolean isExtendedSSA() {
        return this.options.extended();
    }

    public ShimpleOptions getOptions() {
        return this.options;
    }

    public void makeUniqueLocalNames() {
        this.sbb.makeUniqueLocalNames();
    }
}

