/*
 * Decompiled with CFR 0.152.
 */
package soot.options;

import java.util.Deque;
import java.util.LinkedList;
import java.util.StringTokenizer;
import soot.Pack;
import soot.PackManager;
import soot.PhaseOptions;
import soot.Transform;
import soot.plugins.internal.PluginLoader;

abstract class OptionsBase {
    private final Deque<String> options = new LinkedList<String>();
    protected LinkedList<String> classes = new LinkedList();

    OptionsBase() {
    }

    private String pad(int initial, String opts, int tab, String desc) {
        int i;
        StringBuilder b = new StringBuilder();
        for (i = 0; i < initial; ++i) {
            b.append(' ');
        }
        b.append(opts);
        if (tab <= opts.length()) {
            b.append('\n');
            i = 0;
        } else {
            i = opts.length() + initial;
        }
        while (i <= tab) {
            b.append(' ');
            ++i;
        }
        StringTokenizer t2 = new StringTokenizer(desc);
        while (t2.hasMoreTokens()) {
            String s2 = t2.nextToken();
            if (i + s2.length() > 78) {
                b.append('\n');
                for (i = 0; i <= tab; ++i) {
                    b.append(' ');
                }
            }
            b.append(s2);
            b.append(' ');
            i += s2.length() + 1;
        }
        b.append('\n');
        return b.toString();
    }

    protected String padOpt(String opts, String desc) {
        return this.pad(1, opts, 30, desc);
    }

    protected String padVal(String vals, String desc) {
        return this.pad(4, vals, 32, desc);
    }

    protected String getPhaseUsage() {
        StringBuilder b = new StringBuilder();
        b.append("\nPhases and phase options:\n");
        for (Pack p : PackManager.v().allPacks()) {
            b.append(this.padOpt(p.getPhaseName(), p.getDeclaredOptions()));
            for (Transform ph : p) {
                b.append(this.padVal(ph.getPhaseName(), ph.getDeclaredOptions()));
            }
        }
        return b.toString();
    }

    protected void pushOption(String option) {
        this.options.push(option);
    }

    protected boolean hasMoreOptions() {
        return !this.options.isEmpty();
    }

    protected String nextOption() {
        return this.options.removeFirst();
    }

    public LinkedList<String> classes() {
        return this.classes;
    }

    public boolean setPhaseOption(String phase, String option) {
        return PhaseOptions.v().processPhaseOptions(phase, option);
    }

    protected boolean loadPluginConfiguration(String file) {
        return PluginLoader.load(file);
    }
}

