/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.validation;

import java.util.List;
import soot.Body;
import soot.Local;
import soot.SootMethod;
import soot.Type;
import soot.validation.BodyValidator;
import soot.validation.ValidationException;

public enum TypesValidator implements BodyValidator
{
    INSTANCE;


    public static TypesValidator v() {
        return INSTANCE;
    }

    @Override
    public void validate(Body body, List<ValidationException> exceptions) {
        SootMethod method = body.getMethod();
        if (method != null) {
            if (!method.getReturnType().isAllowedInFinalCode()) {
                exceptions.add(new ValidationException(method, "Return type not allowed in final code: " + method.getReturnType(), "return type not allowed in final code:" + method.getReturnType() + "\n method: " + method));
            }
            for (Type t2 : method.getParameterTypes()) {
                if (t2.isAllowedInFinalCode()) continue;
                exceptions.add(new ValidationException(method, "Parameter type not allowed in final code: " + t2, "parameter type not allowed in final code:" + t2 + "\n method: " + method));
            }
        }
        for (Local l : body.getLocals()) {
            Type t3 = l.getType();
            if (t3.isAllowedInFinalCode()) continue;
            exceptions.add(new ValidationException(l, "Local type not allowed in final code: " + t3, "(" + method + ") local type not allowed in final code: " + t3 + " local: " + l));
        }
    }

    @Override
    public boolean isBasicValidator() {
        return true;
    }
}

