/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.validation;

import java.util.List;
import soot.Body;
import soot.SootMethod;
import soot.Unit;
import soot.VoidType;
import soot.baf.GotoInst;
import soot.baf.ReturnInst;
import soot.baf.ReturnVoidInst;
import soot.baf.ThrowInst;
import soot.jimple.GotoStmt;
import soot.jimple.NopStmt;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.ThrowStmt;
import soot.validation.BodyValidator;
import soot.validation.ValidationException;

public enum ReturnStatementsValidator implements BodyValidator
{
    INSTANCE;


    public static ReturnStatementsValidator v() {
        return INSTANCE;
    }

    @Override
    public void validate(Body body, List<ValidationException> exceptions) {
        SootMethod method = body.getMethod();
        for (Unit u : body.getUnits()) {
            if (u instanceof ThrowStmt || u instanceof ThrowInst) {
                return;
            }
            if (!(u instanceof ReturnStmt || u instanceof ReturnInst ? !(method.getReturnType() instanceof VoidType) : (u instanceof ReturnVoidStmt || u instanceof ReturnVoidInst) && method.getReturnType() instanceof VoidType)) continue;
            return;
        }
        Object last = body.getUnits().getLast();
        while (last instanceof NopStmt) {
            last = body.getUnits().getPredOf(last);
        }
        if (last instanceof GotoStmt || last instanceof GotoInst || last instanceof ThrowStmt || last instanceof ThrowInst) {
            return;
        }
        exceptions.add(new ValidationException(method, "The method does not contain a return statement, or the return statement is not of the appropriate type", "Body of method " + method.getSignature() + " does not contain a return statement, or the return statement is not of the appropriate type"));
    }

    @Override
    public boolean isBasicValidator() {
        return true;
    }
}

