/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.validation;

import java.util.List;
import soot.Body;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Unit;
import soot.jimple.InterfaceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.VirtualInvokeExpr;
import soot.validation.BodyValidator;
import soot.validation.ValidationException;

public enum InvokeValidator implements BodyValidator
{
    INSTANCE;


    public static InvokeValidator v() {
        return INSTANCE;
    }

    @Override
    public void validate(Body body, List<ValidationException> exceptions) {
        SootClass objClass = Scene.v().getObjectType().getSootClass();
        for (Unit unit : body.getUnits()) {
            Stmt statement;
            if (!(unit instanceof Stmt) || !(statement = (Stmt)unit).containsInvokeExpr()) continue;
            InvokeExpr ie = statement.getInvokeExpr();
            SootMethodRef methodRef = ie.getMethodRef();
            try {
                SootMethod method = methodRef.resolve();
                if (method.isPhantom()) continue;
                if (method.isStaticInitializer()) {
                    exceptions.add(new ValidationException(unit, "Calling <clinit> methods is not allowed."));
                    continue;
                }
                if (method.isStatic()) {
                    if (ie instanceof StaticInvokeExpr) continue;
                    exceptions.add(new ValidationException(unit, "Should use staticinvoke for static methods."));
                    continue;
                }
                SootClass clazzDeclaring = method.getDeclaringClass();
                if (clazzDeclaring.isInterface()) {
                    if (ie instanceof InterfaceInvokeExpr || ie instanceof VirtualInvokeExpr || ie instanceof SpecialInvokeExpr) continue;
                    exceptions.add(new ValidationException(unit, "Should use interface/virtual/specialinvoke for interface methods."));
                    continue;
                }
                if (method.isPrivate() || method.isConstructor()) {
                    if (ie instanceof SpecialInvokeExpr) continue;
                    String type = method.isPrivate() ? "private methods" : "constructors";
                    exceptions.add(new ValidationException(unit, "Should use specialinvoke for " + type + "."));
                    continue;
                }
                if (methodRef.getDeclaringClass().isInterface() && objClass.equals(clazzDeclaring)) {
                    if (ie instanceof InterfaceInvokeExpr || ie instanceof VirtualInvokeExpr || ie instanceof SpecialInvokeExpr) continue;
                    exceptions.add(new ValidationException(unit, "Should use interface/virtual/specialinvoke for java.lang.Object methods."));
                    continue;
                }
                if (ie instanceof VirtualInvokeExpr || ie instanceof SpecialInvokeExpr) continue;
                exceptions.add(new ValidationException(unit, "Should use virtualinvoke or specialinvoke."));
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public boolean isBasicValidator() {
        return false;
    }
}

