/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.validation;

import java.util.List;
import soot.Body;
import soot.IdentityUnit;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.jimple.ParameterRef;
import soot.jimple.ThisRef;
import soot.validation.BodyValidator;
import soot.validation.ValidationException;

public enum IdentityValidator implements BodyValidator
{
    INSTANCE;


    public static IdentityValidator v() {
        return INSTANCE;
    }

    @Override
    public void validate(Body body, List<ValidationException> exceptions) {
        SootMethod method = body.getMethod();
        int paramCount = method.getParameterCount();
        boolean[] parameterRefs = new boolean[paramCount];
        boolean hasThisLocal = false;
        for (Unit u : body.getUnits()) {
            if (!(u instanceof IdentityUnit)) continue;
            IdentityUnit id = (IdentityUnit)u;
            Value rhs = id.getRightOp();
            if (rhs instanceof ThisRef) {
                hasThisLocal = true;
                continue;
            }
            if (!(rhs instanceof ParameterRef)) continue;
            ParameterRef ref = (ParameterRef)rhs;
            if (ref.getIndex() < 0 || ref.getIndex() >= paramCount) {
                if (paramCount == 0) {
                    exceptions.add(new ValidationException(id, "This method has no parameters, so no parameter reference is allowed"));
                } else {
                    exceptions.add(new ValidationException(id, String.format("Parameter reference index must be between 0 and %d (inclusive)", paramCount - 1)));
                }
                return;
            }
            if (parameterRefs[ref.getIndex()]) {
                exceptions.add(new ValidationException(id, String.format("Only one local for parameter %d is allowed", ref.getIndex())));
            }
            parameterRefs[ref.getIndex()] = true;
        }
        if (!method.isStatic() && !hasThisLocal) {
            exceptions.add(new ValidationException(body, String.format("The method %s is not static, but does not have a this local", method.getSignature())));
        }
        for (int i = 0; i < paramCount; ++i) {
            if (parameterRefs[i]) continue;
            exceptions.add(new ValidationException(body, String.format("There is no parameter local for parameter number %d", i)));
        }
    }

    @Override
    public boolean isBasicValidator() {
        return true;
    }
}

