/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.typing.fast;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.IntType;
import soot.Local;
import soot.ShortType;
import soot.Type;
import soot.Value;
import soot.jimple.JimpleBody;
import soot.jimple.Stmt;
import soot.jimple.toolkits.typing.fast.AugEvalFunction;
import soot.jimple.toolkits.typing.fast.AugHierarchy;
import soot.jimple.toolkits.typing.fast.IUseVisitor;
import soot.jimple.toolkits.typing.fast.Integer127Type;
import soot.jimple.toolkits.typing.fast.Integer1Type;
import soot.jimple.toolkits.typing.fast.Integer32767Type;
import soot.jimple.toolkits.typing.fast.TypeResolver;
import soot.jimple.toolkits.typing.fast.Typing;
import soot.jimple.toolkits.typing.fast.WeakObjectType;

public class TypePromotionUseVisitor
implements IUseVisitor {
    private static final Logger logger = LoggerFactory.getLogger(TypePromotionUseVisitor.class);
    private final ByteType byteType = ByteType.v();
    private final Integer32767Type integer32767Type = Integer32767Type.v();
    private final Integer127Type integer127Type = Integer127Type.v();
    private final JimpleBody jb;
    private final Typing tg;
    public boolean fail;
    public boolean typingChanged;

    public TypePromotionUseVisitor(JimpleBody jb, Typing tg) {
        this.jb = jb;
        this.tg = tg;
        this.fail = false;
        this.typingChanged = false;
    }

    private Type promote(Type tlow, Type thigh) {
        if (tlow instanceof Integer1Type) {
            if (thigh instanceof IntType) {
                return Integer127Type.v();
            }
            if (thigh instanceof ShortType) {
                return this.byteType;
            }
            if (thigh instanceof BooleanType || thigh instanceof ByteType || thigh instanceof CharType || thigh instanceof Integer127Type || thigh instanceof Integer32767Type) {
                return thigh;
            }
            throw new RuntimeException();
        }
        if (tlow instanceof Integer127Type) {
            if (thigh instanceof ShortType) {
                return this.byteType;
            }
            if (thigh instanceof IntType) {
                return this.integer127Type;
            }
            if (thigh instanceof ByteType || thigh instanceof CharType || thigh instanceof Integer32767Type) {
                return thigh;
            }
            throw new RuntimeException();
        }
        if (tlow instanceof Integer32767Type) {
            if (thigh instanceof IntType) {
                return this.integer32767Type;
            }
            if (thigh instanceof ShortType || thigh instanceof CharType) {
                return thigh;
            }
            throw new RuntimeException();
        }
        throw new RuntimeException();
    }

    @Override
    public Value visit(Value op, Type useType, Stmt stmt, boolean checkOnly) {
        if (this.finish()) {
            return op;
        }
        Type t2 = AugEvalFunction.eval_(this.tg, op, stmt, this.jb);
        if (!AugHierarchy.ancestor_(useType, t2)) {
            logger.error(String.format("Failed Typing in %s at statement %s: Is not cast compatible: %s <-- %s", this.jb.getMethod().getSignature(), stmt, useType, t2));
            this.fail = true;
        } else if (!checkOnly && op instanceof Local && (t2 instanceof Integer1Type || t2 instanceof Integer127Type || t2 instanceof Integer32767Type || t2 instanceof WeakObjectType)) {
            Type t_;
            Local v = (Local)op;
            if (!TypeResolver.typesEqual(t2, useType) && !TypeResolver.typesEqual(t2, t_ = this.promote(t2, useType))) {
                this.tg.set(v, t_);
                this.typingChanged = true;
            }
        }
        return op;
    }

    @Override
    public boolean finish() {
        return this.typingChanged || this.fail;
    }
}

