/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.typing.fast;

import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.IntType;
import soot.IntegerType;
import soot.ShortType;
import soot.jimple.toolkits.typing.fast.Integer127Type;
import soot.jimple.toolkits.typing.fast.Integer1Type;
import soot.jimple.toolkits.typing.fast.Integer32767Type;

public class IntUtils {
    public static IntegerType getTypeByWidth(int maxValue) {
        switch (maxValue) {
            case 1: {
                return Integer1Type.v();
            }
            case 127: {
                return Integer127Type.v();
            }
            case 32767: {
                return Integer32767Type.v();
            }
            case 0x7FFFFFFF: {
                return IntType.v();
            }
        }
        throw new RuntimeException("Unsupported width: " + maxValue);
    }

    public static int getMaxValue(IntegerType t2) {
        if (t2 instanceof Integer1Type || t2 instanceof BooleanType) {
            return 1;
        }
        if (t2 instanceof Integer127Type || t2 instanceof ByteType) {
            return 127;
        }
        if (t2 instanceof Integer32767Type || t2 instanceof ShortType || t2 instanceof CharType) {
            return Short.MAX_VALUE;
        }
        if (t2 instanceof IntType) {
            return Integer.MAX_VALUE;
        }
        throw new RuntimeException("Unsupported type: " + t2);
    }
}

