/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.thread.synchronization;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.EquivalentValue;
import soot.G;
import soot.Local;
import soot.PhaseOptions;
import soot.PointsToAnalysis;
import soot.RefType;
import soot.Scene;
import soot.SceneTransformer;
import soot.Singletons;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.Value;
import soot.jimple.DefinitionStmt;
import soot.jimple.FieldRef;
import soot.jimple.InstanceFieldRef;
import soot.jimple.Ref;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.spark.pag.PAG;
import soot.jimple.spark.sets.HashPointsToSet;
import soot.jimple.spark.sets.PointsToSetInternal;
import soot.jimple.toolkits.callgraph.ReachableMethods;
import soot.jimple.toolkits.infoflow.ClassInfoFlowAnalysis;
import soot.jimple.toolkits.infoflow.FakeJimpleLocal;
import soot.jimple.toolkits.infoflow.SmartMethodInfoFlowAnalysis;
import soot.jimple.toolkits.pointer.RWSet;
import soot.jimple.toolkits.thread.ThreadLocalObjectsAnalysis;
import soot.jimple.toolkits.thread.mhp.MhpTester;
import soot.jimple.toolkits.thread.mhp.SynchObliviousMhpAnalysis;
import soot.jimple.toolkits.thread.synchronization.CriticalSection;
import soot.jimple.toolkits.thread.synchronization.CriticalSectionAwareSideEffectAnalysis;
import soot.jimple.toolkits.thread.synchronization.CriticalSectionDataDependency;
import soot.jimple.toolkits.thread.synchronization.CriticalSectionGroup;
import soot.jimple.toolkits.thread.synchronization.CriticalSectionInterferenceGraph;
import soot.jimple.toolkits.thread.synchronization.DeadlockDetector;
import soot.jimple.toolkits.thread.synchronization.LockAllocationBodyTransformer;
import soot.jimple.toolkits.thread.synchronization.LockableReferenceAnalysis;
import soot.jimple.toolkits.thread.synchronization.NewStaticLock;
import soot.jimple.toolkits.thread.synchronization.SynchronizedRegionFinder;
import soot.jimple.toolkits.thread.synchronization.SynchronizedRegionFlowPair;
import soot.toolkits.graph.BriefUnitGraph;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.graph.ExceptionalUnitGraphFactory;
import soot.toolkits.graph.HashMutableEdgeLabelledDirectedGraph;
import soot.toolkits.scalar.FlowSet;
import soot.toolkits.scalar.LocalDefs;

public class LockAllocator
extends SceneTransformer {
    private static final Logger logger = LoggerFactory.getLogger(LockAllocator.class);
    List<CriticalSection> criticalSections = null;
    CriticalSectionInterferenceGraph interferenceGraph = null;
    DirectedGraph deadlockGraph = null;
    boolean optionOneGlobalLock = false;
    boolean optionStaticLocks = false;
    boolean optionUseLocksets = false;
    boolean optionLeaveOriginalLocks = false;
    boolean optionIncludeEmptyPossibleEdges = false;
    boolean optionAvoidDeadlock = true;
    boolean optionOpenNesting = true;
    boolean optionDoMHP = false;
    boolean optionDoTLO = false;
    boolean optionOnFlyTLO = false;
    boolean optionPrintMhpSummary = true;
    boolean optionPrintGraph = false;
    boolean optionPrintTable = false;
    boolean optionPrintDebug = false;

    public LockAllocator(Singletons.Global g2) {
    }

    public static LockAllocator v() {
        return G.v().soot_jimple_toolkits_thread_synchronization_LockAllocator();
    }

    @Override
    protected void internalTransform(String phaseName, Map<String, String> options) {
        CriticalSectionInterferenceGraph ig;
        String lockingScheme = PhaseOptions.getString(options, "locking-scheme");
        if (lockingScheme.equals("fine-grained")) {
            this.optionOneGlobalLock = false;
            this.optionStaticLocks = false;
            this.optionUseLocksets = true;
            this.optionLeaveOriginalLocks = false;
        }
        if (lockingScheme.equals("medium-grained")) {
            this.optionOneGlobalLock = false;
            this.optionStaticLocks = false;
            this.optionUseLocksets = false;
            this.optionLeaveOriginalLocks = false;
        }
        if (lockingScheme.equals("coarse-grained")) {
            this.optionOneGlobalLock = false;
            this.optionStaticLocks = true;
            this.optionUseLocksets = false;
            this.optionLeaveOriginalLocks = false;
        }
        if (lockingScheme.equals("single-static")) {
            this.optionOneGlobalLock = true;
            this.optionStaticLocks = true;
            this.optionUseLocksets = false;
            this.optionLeaveOriginalLocks = false;
        }
        if (lockingScheme.equals("leave-original")) {
            this.optionOneGlobalLock = false;
            this.optionStaticLocks = false;
            this.optionUseLocksets = false;
            this.optionLeaveOriginalLocks = true;
        }
        this.optionAvoidDeadlock = PhaseOptions.getBoolean(options, "avoid-deadlock");
        this.optionOpenNesting = PhaseOptions.getBoolean(options, "open-nesting");
        this.optionDoMHP = PhaseOptions.getBoolean(options, "do-mhp");
        this.optionDoTLO = PhaseOptions.getBoolean(options, "do-tlo");
        this.optionPrintGraph = PhaseOptions.getBoolean(options, "print-graph");
        this.optionPrintTable = PhaseOptions.getBoolean(options, "print-table");
        this.optionPrintDebug = PhaseOptions.getBoolean(options, "print-debug");
        SynchObliviousMhpAnalysis mhp = null;
        if (this.optionDoMHP && Scene.v().getPointsToAnalysis() instanceof PAG) {
            logger.debug("[wjtp.tn] *** Build May-Happen-in-Parallel Info *** " + new Date());
            mhp = new SynchObliviousMhpAnalysis();
            if (this.optionPrintMhpSummary) {
                mhp.printMhpSummary();
            }
        }
        ThreadLocalObjectsAnalysis tlo = null;
        if (this.optionDoTLO) {
            logger.debug("[wjtp.tn] *** Find Thread-Local Objects *** " + new Date());
            tlo = mhp != null ? new ThreadLocalObjectsAnalysis(mhp) : new ThreadLocalObjectsAnalysis(new SynchObliviousMhpAnalysis());
            if (!this.optionOnFlyTLO) {
                tlo.precompute();
                logger.debug("[wjtp.tn] TLO totals (#analyzed/#encountered): " + SmartMethodInfoFlowAnalysis.counter + "/" + ClassInfoFlowAnalysis.methodCount);
            } else {
                logger.debug("[wjtp.tn] TLO so far (#analyzed/#encountered): " + SmartMethodInfoFlowAnalysis.counter + "/" + ClassInfoFlowAnalysis.methodCount);
            }
        }
        Date start = new Date();
        logger.debug("[wjtp.tn] *** Find and Name Transactions *** " + start);
        HashMap<SootMethod, FlowSet> methodToFlowSet = new HashMap<SootMethod, FlowSet>();
        HashMap<SootMethod, ExceptionalUnitGraph> methodToExcUnitGraph = new HashMap<SootMethod, ExceptionalUnitGraph>();
        for (SootClass sootClass : Scene.v().getApplicationClasses()) {
            for (SootMethod method : sootClass.getMethods()) {
                if (!method.isConcrete()) continue;
                Body b = method.retrieveActiveBody();
                ExceptionalUnitGraph eug = ExceptionalUnitGraphFactory.createExceptionalUnitGraph(b);
                methodToExcUnitGraph.put(method, eug);
                SynchronizedRegionFinder ta = new SynchronizedRegionFinder(eug, b, this.optionPrintDebug, this.optionOpenNesting, tlo);
                UnitPatchingChain units = b.getUnits();
                Unit lastUnit = (Unit)units.getLast();
                FlowSet fs = (FlowSet)ta.getFlowBefore(lastUnit);
                methodToFlowSet.put(method, fs);
            }
        }
        this.criticalSections = new Vector<CriticalSection>();
        for (FlowSet fs : methodToFlowSet.values()) {
            List fList = fs.toList();
            for (int i = 0; i < fList.size(); ++i) {
                this.criticalSections.add(((SynchronizedRegionFlowPair)fList.get((int)i)).tn);
            }
        }
        this.assignNamesToTransactions(this.criticalSections);
        if (this.optionOnFlyTLO) {
            logger.debug("[wjtp.tn] TLO so far (#analyzed/#encountered): " + SmartMethodInfoFlowAnalysis.counter + "/" + ClassInfoFlowAnalysis.methodCount);
        }
        logger.debug("[wjtp.tn] *** Find Transitive Read/Write Sets *** " + new Date());
        PointsToAnalysis pointsToAnalysis = Scene.v().getPointsToAnalysis();
        CriticalSectionAwareSideEffectAnalysis tasea = null;
        tasea = new CriticalSectionAwareSideEffectAnalysis(pointsToAnalysis, Scene.v().getCallGraph(), this.optionOpenNesting ? this.criticalSections : null, tlo);
        for (CriticalSection tn : this.criticalSections) {
            for (Unit unit : tn.invokes) {
                RWSet stmtWrite;
                HashSet uses;
                Stmt stmt = (Stmt)unit;
                RWSet stmtRead = tasea.readSet(tn.method, stmt, tn, uses = new HashSet());
                if (stmtRead != null) {
                    tn.read.union(stmtRead);
                }
                if ((stmtWrite = tasea.writeSet(tn.method, stmt, tn, uses)) == null) continue;
                tn.write.union(stmtWrite);
            }
        }
        long longTime = (new Date().getTime() - start.getTime()) / 100L;
        float time = (float)longTime / 10.0f;
        if (this.optionOnFlyTLO) {
            logger.debug("[wjtp.tn] TLO totals (#analyzed/#encountered): " + SmartMethodInfoFlowAnalysis.counter + "/" + ClassInfoFlowAnalysis.methodCount);
            logger.debug("[wjtp.tn] Time for stages utilizing on-fly TLO: " + time + "s");
        }
        logger.debug("[wjtp.tn] *** Calculate Locking Groups *** " + new Date());
        this.interferenceGraph = ig = new CriticalSectionInterferenceGraph(this.criticalSections, mhp, this.optionOneGlobalLock, this.optionLeaveOriginalLocks, this.optionIncludeEmptyPossibleEdges);
        logger.debug("[wjtp.tn] *** Detect the Possibility of Deadlock *** " + new Date());
        DeadlockDetector dd = new DeadlockDetector(this.optionPrintDebug, this.optionAvoidDeadlock, true, this.criticalSections);
        if (!this.optionUseLocksets) {
            this.deadlockGraph = dd.detectComponentBasedDeadlock();
        }
        logger.debug("[wjtp.tn] *** Calculate Locking Objects *** " + new Date());
        if (!this.optionStaticLocks) {
            for (CriticalSection tn : this.criticalSections) {
                if (tn.setNumber <= 0) continue;
                for (CriticalSectionDataDependency tdd : tn.edges) {
                    tn.group.rwSet.union(tdd.rw);
                }
            }
        }
        HashMap<Value, Integer> lockToLockNum = null;
        ArrayList<PointsToSetInternal> lockPTSets = null;
        if (this.optionLeaveOriginalLocks) {
            this.analyzeExistingLocks(this.criticalSections, ig);
        } else if (this.optionStaticLocks) {
            this.setFlagsForStaticAllocations(ig);
        } else {
            this.setFlagsForDynamicAllocations(ig);
            lockPTSets = new ArrayList<PointsToSetInternal>();
            lockToLockNum = new HashMap<Value, Integer>();
            this.findLockableReferences(this.criticalSections, pointsToAnalysis, tasea, lockToLockNum, lockPTSets);
            if (this.optionUseLocksets) {
                for (CriticalSection tn : this.criticalSections) {
                    if (tn.group == null) continue;
                    logger.debug("[wjtp.tn] " + tn.name + " lockset: " + LockAllocator.locksetToLockNumString(tn.lockset, lockToLockNum) + (tn.group.useLocksets ? "" : " (placeholder)"));
                }
            }
        }
        if (this.optionUseLocksets) {
            logger.debug("[wjtp.tn] *** Detect " + (this.optionAvoidDeadlock ? "and Correct " : "") + "the Possibility of Deadlock for Locksets *** " + new Date());
            this.deadlockGraph = dd.detectLocksetDeadlock(lockToLockNum, lockPTSets);
            if (this.optionPrintDebug) {
                ((HashMutableEdgeLabelledDirectedGraph)this.deadlockGraph).printGraph();
            }
            logger.debug("[wjtp.tn] *** Reorder Locksets to Avoid Deadlock *** " + new Date());
            dd.reorderLocksets(lockToLockNum, (HashMutableEdgeLabelledDirectedGraph)this.deadlockGraph);
        }
        logger.debug("[wjtp.tn] *** Print Output and Transform Program *** " + new Date());
        if (this.optionPrintGraph) {
            this.printGraph(this.criticalSections, ig, lockToLockNum);
        }
        if (this.optionPrintTable) {
            this.printTable(this.criticalSections, mhp);
            this.printGroups(this.criticalSections, ig);
        }
        if (!this.optionLeaveOriginalLocks) {
            boolean[] insertedGlobalLock = new boolean[ig.groupCount()];
            insertedGlobalLock[0] = false;
            for (int i = 1; i < ig.groupCount(); ++i) {
                CriticalSectionGroup tnGroup = ig.groups().get(i);
                insertedGlobalLock[i] = !this.optionOneGlobalLock && (tnGroup.useDynamicLock || tnGroup.useLocksets);
            }
            for (SootClass appClass : Scene.v().getApplicationClasses()) {
                for (SootMethod method : appClass.getMethods()) {
                    FlowSet fs;
                    if (!method.isConcrete() || (fs = (FlowSet)methodToFlowSet.get(method)) == null) continue;
                    LockAllocationBodyTransformer.v().internalTransform(method.getActiveBody(), fs, ig.groups(), insertedGlobalLock);
                }
            }
        }
    }

    protected void findLockableReferences(List<CriticalSection> AllTransactions, PointsToAnalysis pta, CriticalSectionAwareSideEffectAnalysis tasea, Map<Value, Integer> lockToLockNum, List<PointsToSetInternal> lockPTSets) {
        for (CriticalSection tn : AllTransactions) {
            int group = tn.setNumber - 1;
            if (group < 0 || !tn.group.useDynamicLock && !tn.group.useLocksets) continue;
            logger.debug("[wjtp.tn] * " + tn.name + " *");
            LockableReferenceAnalysis la = new LockableReferenceAnalysis(new BriefUnitGraph(tn.method.retrieveActiveBody()));
            tn.lockset = la.getLocksetOf(tasea, tn.group.rwSet, tn);
            if (this.optionUseLocksets) {
                if (tn.lockset == null || tn.lockset.size() <= 0) {
                    tn.group.useLocksets = false;
                    NewStaticLock newStaticLock = new NewStaticLock(tn.method.getDeclaringClass());
                    EquivalentValue newStaticLockEqVal = new EquivalentValue(newStaticLock);
                    for (CriticalSection groupTn : tn.group) {
                        groupTn.lockset = new ArrayList<EquivalentValue>();
                        groupTn.lockset.add(newStaticLockEqVal);
                    }
                    Integer lockNum = new Integer(-lockPTSets.size());
                    logger.debug("[wjtp.tn] Lock: num " + lockNum + " type " + newStaticLock.getType() + " obj " + newStaticLock);
                    lockToLockNum.put(newStaticLockEqVal, lockNum);
                    lockToLockNum.put(newStaticLock, lockNum);
                    HashPointsToSet dummyLockPT = new HashPointsToSet(newStaticLock.getType(), (PAG)pta);
                    lockPTSets.add(dummyLockPT);
                    continue;
                }
                for (EquivalentValue lockEqVal : tn.lockset) {
                    Integer lockNum;
                    Local base;
                    Value lock = lockEqVal.getValue();
                    PointsToSetInternal lockPT = lock instanceof Local ? (PointsToSetInternal)pta.reachingObjects((Local)lock) : (lock instanceof StaticFieldRef ? null : (lock instanceof InstanceFieldRef ? ((base = (Local)((InstanceFieldRef)lock).getBase()) instanceof FakeJimpleLocal ? (PointsToSetInternal)pta.reachingObjects(((FakeJimpleLocal)base).getRealLocal(), ((FieldRef)lock).getField()) : (PointsToSetInternal)pta.reachingObjects(base, ((FieldRef)lock).getField())) : (lock instanceof NewStaticLock ? null : null)));
                    if (lockPT != null) {
                        boolean foundLock = false;
                        for (int i = 0; i < lockPTSets.size(); ++i) {
                            PointsToSetInternal otherLockPT = lockPTSets.get(i);
                            if (!lockPT.hasNonEmptyIntersection(otherLockPT)) continue;
                            logger.debug("[wjtp.tn] Lock: num " + i + " type " + lock.getType() + " obj " + lock);
                            lockToLockNum.put(lock, new Integer(i));
                            otherLockPT.addAll(lockPT, null);
                            foundLock = true;
                            break;
                        }
                        if (foundLock) continue;
                        logger.debug("[wjtp.tn] Lock: num " + lockPTSets.size() + " type " + lock.getType() + " obj " + lock);
                        lockToLockNum.put(lock, new Integer(lockPTSets.size()));
                        HashPointsToSet otherLockPT = new HashPointsToSet(lockPT.getType(), (PAG)pta);
                        lockPTSets.add(otherLockPT);
                        ((PointsToSetInternal)otherLockPT).addAll(lockPT, null);
                        continue;
                    }
                    if (lockToLockNum.get(lockEqVal) != null) {
                        lockNum = lockToLockNum.get(lockEqVal);
                        logger.debug("[wjtp.tn] Lock: num " + lockNum + " type " + lock.getType() + " obj " + lock);
                        lockToLockNum.put(lock, lockNum);
                        continue;
                    }
                    lockNum = new Integer(-lockPTSets.size());
                    logger.debug("[wjtp.tn] Lock: num " + lockNum + " type " + lock.getType() + " obj " + lock);
                    lockToLockNum.put(lockEqVal, lockNum);
                    lockToLockNum.put(lock, lockNum);
                    HashPointsToSet dummyLockPT = new HashPointsToSet(lock.getType(), (PAG)pta);
                    lockPTSets.add(dummyLockPT);
                }
                continue;
            }
            if (tn.lockset == null || tn.lockset.size() != 1) {
                tn.lockObject = null;
                tn.group.useDynamicLock = false;
                tn.group.lockObject = null;
                continue;
            }
            tn.lockObject = tn.lockset.get(0);
            if (tn.group.lockObject != null && !(tn.lockObject instanceof Ref)) continue;
            tn.group.lockObject = tn.lockObject;
        }
        if (this.optionUseLocksets) {
            for (int i = 0; i < lockPTSets.size(); ++i) {
                PointsToSetInternal pts = lockPTSets.get(i);
                if (pts.size() != 1) continue;
            }
        }
    }

    public void setFlagsForDynamicAllocations(CriticalSectionInterferenceGraph ig) {
        for (int group = 0; group < ig.groupCount() - 1; ++group) {
            CriticalSectionGroup tnGroup = ig.groups().get(group + 1);
            if (this.optionUseLocksets) {
                tnGroup.useLocksets = true;
            } else {
                tnGroup.isDynamicLock = tnGroup.rwSet.getGlobals().size() == 0;
                tnGroup.useDynamicLock = true;
                tnGroup.lockObject = null;
            }
            if (tnGroup.rwSet.size() > 0) continue;
            if (this.optionUseLocksets) {
                tnGroup.useLocksets = false;
                continue;
            }
            tnGroup.isDynamicLock = false;
            tnGroup.useDynamicLock = false;
        }
    }

    public void setFlagsForStaticAllocations(CriticalSectionInterferenceGraph ig) {
        for (int group = 0; group < ig.groupCount() - 1; ++group) {
            CriticalSectionGroup tnGroup = ig.groups().get(group + 1);
            tnGroup.isDynamicLock = false;
            tnGroup.useDynamicLock = false;
            tnGroup.lockObject = null;
        }
    }

    private void analyzeExistingLocks(List<CriticalSection> AllTransactions, CriticalSectionInterferenceGraph ig) {
        this.setFlagsForStaticAllocations(ig);
        for (CriticalSection tn : AllTransactions) {
            List<Unit> rDefs;
            if (tn.setNumber <= 0) continue;
            LocalDefs ld = G.v().soot_toolkits_scalar_LocalDefsFactory().newLocalDefs(tn.method.retrieveActiveBody());
            if (tn.origLock == null || !(tn.origLock instanceof Local) || (rDefs = ld.getDefsOfAt((Local)tn.origLock, tn.entermonitor)) == null) continue;
            for (Unit u : rDefs) {
                Stmt next = (Stmt)u;
                if (next instanceof DefinitionStmt) {
                    Value rightOp = ((DefinitionStmt)next).getRightOp();
                    if (rightOp instanceof FieldRef) {
                        if (((FieldRef)rightOp).getField().isStatic()) {
                            tn.group.lockObject = rightOp;
                            continue;
                        }
                        tn.group.isDynamicLock = true;
                        tn.group.useDynamicLock = true;
                        tn.group.lockObject = tn.origLock;
                        continue;
                    }
                    tn.group.isDynamicLock = true;
                    tn.group.useDynamicLock = true;
                    tn.group.lockObject = tn.origLock;
                    continue;
                }
                tn.group.isDynamicLock = true;
                tn.group.useDynamicLock = true;
                tn.group.lockObject = tn.origLock;
            }
        }
    }

    public static String locksetToLockNumString(List<EquivalentValue> lockset, Map<Value, Integer> lockToLockNum) {
        if (lockset == null) {
            return "null";
        }
        Object ret = "[";
        boolean first = true;
        for (EquivalentValue lockEqVal : lockset) {
            if (!first) {
                ret = (String)ret + " ";
            }
            first = false;
            ret = (String)ret + lockToLockNum.get(lockEqVal.getValue());
        }
        return (String)ret + "]";
    }

    public void assignNamesToTransactions(List<CriticalSection> AllTransactions) {
        ArrayList<String> methodNamesTemp = new ArrayList<String>();
        for (CriticalSection tn1 : AllTransactions) {
            String mname = tn1.method.getSignature();
            if (methodNamesTemp.contains(mname)) continue;
            methodNamesTemp.add(mname);
        }
        Object[] methodNames = new String[1];
        methodNames = methodNamesTemp.toArray(methodNames);
        Arrays.sort(methodNames);
        int[][] identMatrix = new int[methodNames.length][CriticalSection.nextIDNum - methodNames.length + 2];
        for (int i = 0; i < methodNames.length; ++i) {
            identMatrix[i][0] = 0;
            for (int j = 1; j < CriticalSection.nextIDNum - methodNames.length + 1; ++j) {
                identMatrix[i][j] = 50000;
            }
        }
        for (CriticalSection tn1 : AllTransactions) {
            int methodNum = Arrays.binarySearch(methodNames, tn1.method.getSignature());
            int[] nArray = identMatrix[methodNum];
            nArray[0] = nArray[0] + 1;
            identMatrix[methodNum][identMatrix[methodNum][0]] = tn1.IDNum;
        }
        for (int j = 0; j < methodNames.length; ++j) {
            identMatrix[j][0] = 0;
            Arrays.sort(identMatrix[j]);
        }
        for (CriticalSection tn1 : AllTransactions) {
            int methodNum = Arrays.binarySearch(methodNames, tn1.method.getSignature());
            int tnNum = Arrays.binarySearch(identMatrix[methodNum], tn1.IDNum) - 1;
            tn1.name = "m" + (methodNum < 10 ? "00" : (methodNum < 100 ? "0" : "")) + methodNum + "n" + (tnNum < 10 ? "0" : "") + tnNum;
        }
    }

    public void printGraph(Collection<CriticalSection> AllTransactions, CriticalSectionInterferenceGraph ig, Map<Value, Integer> lockToLockNum) {
        String[] colors = new String[]{"black", "blue", "blueviolet", "chartreuse", "crimson", "darkgoldenrod1", "darkseagreen", "darkslategray", "deeppink", "deepskyblue1", "firebrick1", "forestgreen", "gold", "gray80", "navy", "pink", "red", "sienna", "turquoise1", "yellow"};
        HashMap<Integer, String> lockColors = new HashMap<Integer, String>();
        int colorNum = 0;
        HashSet<CriticalSection> visited = new HashSet<CriticalSection>();
        logger.debug("[transaction-graph]" + (this.optionUseLocksets ? "" : " strict") + " graph transactions {");
        for (int group = 0; group < ig.groups().size(); ++group) {
            boolean printedHeading = false;
            for (CriticalSection tn : AllTransactions) {
                if (tn.setNumber != group + 1) continue;
                if (!printedHeading) {
                    if (tn.group.useDynamicLock && tn.group.lockObject != null) {
                        String typeString = "";
                        typeString = tn.group.lockObject.getType() instanceof RefType ? ((RefType)tn.group.lockObject.getType()).getSootClass().getShortName() : tn.group.lockObject.getType().toString();
                        logger.debug("[transaction-graph] subgraph cluster_" + (group + 1) + " {\n[transaction-graph] color=blue;\n[transaction-graph] label=\"Lock: a \\n" + typeString + " object\";");
                    } else if (tn.group.useLocksets) {
                        logger.debug("[transaction-graph] subgraph cluster_" + (group + 1) + " {\n[transaction-graph] color=blue;\n[transaction-graph] label=\"Locksets\";");
                    } else {
                        Object objString = "";
                        if (tn.group.lockObject == null) {
                            objString = "lockObj" + (group + 1);
                        } else if (tn.group.lockObject instanceof FieldRef) {
                            SootField field = ((FieldRef)tn.group.lockObject).getField();
                            objString = field.getDeclaringClass().getShortName() + "." + field.getName();
                        } else {
                            objString = tn.group.lockObject.toString();
                        }
                        logger.debug("[transaction-graph] subgraph cluster_" + (group + 1) + " {\n[transaction-graph] color=blue;\n[transaction-graph] label=\"Lock: \\n" + (String)objString + "\";");
                    }
                    printedHeading = true;
                }
                if (Scene.v().getReachableMethods().contains(tn.method)) {
                    logger.debug("[transaction-graph] " + tn.name + " [name=\"" + tn.method.toString() + "\" style=\"setlinewidth(3)\"];");
                } else {
                    logger.debug("[transaction-graph] " + tn.name + " [name=\"" + tn.method.toString() + "\" color=cadetblue1 style=\"setlinewidth(1)\"];");
                }
                if (tn.group.useLocksets) {
                    for (EquivalentValue lockEqVal : tn.lockset) {
                        Integer lockNum = lockToLockNum.get(lockEqVal.getValue());
                        for (CriticalSection tn2 : tn.group) {
                            if (visited.contains(tn2) || !ig.mayHappenInParallel(tn, tn2)) continue;
                            for (EquivalentValue lock2EqVal : tn2.lockset) {
                                Integer lock2Num = lockToLockNum.get(lock2EqVal.getValue());
                                if (lockNum.intValue() != lock2Num.intValue()) continue;
                                if (!lockColors.containsKey(lockNum)) {
                                    lockColors.put(lockNum, colors[colorNum % colors.length]);
                                    ++colorNum;
                                }
                                String color = (String)lockColors.get(lockNum);
                                logger.debug("[transaction-graph] " + tn.name + " -- " + tn2.name + " [color=" + color + " style=" + (lockNum >= 0 ? "dashed" : "solid") + " exactsize=1 style=\"setlinewidth(3)\"];");
                            }
                        }
                        visited.add(tn);
                    }
                    continue;
                }
                for (CriticalSectionDataDependency edge : tn.edges) {
                    CriticalSection tnedge = edge.other;
                    if (tnedge.setNumber != group + 1) continue;
                    logger.debug("[transaction-graph] " + tn.name + " -- " + tnedge.name + " [color=" + (edge.size > 0 ? "black" : "cadetblue1") + " style=" + (tn.setNumber > 0 && tn.group.useDynamicLock ? "dashed" : "solid") + " exactsize=" + edge.size + " style=\"setlinewidth(3)\"];");
                }
            }
            if (!printedHeading) continue;
            logger.debug("[transaction-graph] }");
        }
        boolean printedHeading = false;
        for (CriticalSection tn : AllTransactions) {
            if (tn.setNumber != -1) continue;
            if (!printedHeading) {
                logger.debug("[transaction-graph] subgraph lone {\n[transaction-graph] rank=source;");
                printedHeading = true;
            }
            if (Scene.v().getReachableMethods().contains(tn.method)) {
                logger.debug("[transaction-graph] " + tn.name + " [name=\"" + tn.method.toString() + "\" style=\"setlinewidth(3)\"];");
            } else {
                logger.debug("[transaction-graph] " + tn.name + " [name=\"" + tn.method.toString() + "\" color=cadetblue1 style=\"setlinewidth(1)\"];");
            }
            for (CriticalSectionDataDependency edge : tn.edges) {
                CriticalSection tnedge = edge.other;
                if (tnedge.setNumber == tn.setNumber && tnedge.setNumber != -1) continue;
                logger.debug("[transaction-graph] " + tn.name + " -- " + tnedge.name + " [color=" + (edge.size > 0 ? "black" : "cadetblue1") + " style=" + (tn.setNumber > 0 && tn.group.useDynamicLock ? "dashed" : "solid") + " exactsize=" + edge.size + " style=\"setlinewidth(1)\"];");
            }
        }
        if (printedHeading) {
            logger.debug("[transaction-graph] }");
        }
        logger.debug("[transaction-graph] }");
    }

    public void printTable(Collection<CriticalSection> AllTransactions, MhpTester mhp) {
        logger.debug("[transaction-table] ");
        for (CriticalSection tn : AllTransactions) {
            boolean reachable = false;
            boolean mhpself = false;
            ReachableMethods rm = Scene.v().getReachableMethods();
            reachable = rm.contains(tn.method);
            if (mhp != null) {
                mhpself = mhp.mayHappenInParallel(tn.method, tn.method);
            }
            logger.debug("[transaction-table] Transaction " + tn.name + (reachable ? " reachable" : " dead") + (mhpself ? " [called from >= 2 threads]" : " [called from <= 1 thread]"));
            logger.debug("[transaction-table] Where: " + tn.method.getDeclaringClass().toString() + ":" + tn.method.toString() + ":  ");
            logger.debug("[transaction-table] Orig : " + tn.origLock);
            logger.debug("[transaction-table] Prep : " + tn.prepStmt);
            logger.debug("[transaction-table] Begin: " + tn.entermonitor);
            logger.debug("[transaction-table] End  : early:" + tn.earlyEnds.toString() + " exc:" + tn.exceptionalEnd + " through:" + tn.end + " \n");
            logger.debug("[transaction-table] Size : " + tn.units.size());
            if (tn.read.size() < 100) {
                logger.debug("[transaction-table] Read : " + tn.read.size() + "\n[transaction-table] " + tn.read.toString().replaceAll("\\[", "     : [").replaceAll("\n", "\n[transaction-table] "));
            } else {
                logger.debug("[transaction-table] Read : " + tn.read.size() + "  \n[transaction-table] ");
            }
            if (tn.write.size() < 100) {
                logger.debug("Write: " + tn.write.size() + "\n[transaction-table] " + tn.write.toString().replaceAll("\\[", "     : [").replaceAll("\n", "\n[transaction-table] "));
            } else {
                logger.debug("Write: " + tn.write.size() + "\n[transaction-table] ");
            }
            logger.debug("Edges: (" + tn.edges.size() + ") ");
            Iterator<CriticalSectionDataDependency> tnedgeit = tn.edges.iterator();
            while (tnedgeit.hasNext()) {
                logger.debug(tnedgeit.next().other.name + " ");
            }
            if (tn.group != null && tn.group.useLocksets) {
                logger.debug("\n[transaction-table] Locks: " + tn.lockset);
            } else {
                logger.debug("\n[transaction-table] Lock : " + (String)(tn.setNumber == -1 ? "-" : (tn.lockObject == null ? "Global" : tn.lockObject.toString() + (String)(tn.lockObjectArrayIndex == null ? "" : "[" + tn.lockObjectArrayIndex + "]"))));
            }
            logger.debug("[transaction-table] Group: " + tn.setNumber + "\n[transaction-table] ");
        }
    }

    public void printGroups(Collection<CriticalSection> AllTransactions, CriticalSectionInterferenceGraph ig) {
        logger.debug("[transaction-groups] Group Summaries\n[transaction-groups] ");
        for (int group = 0; group < ig.groupCount() - 1; ++group) {
            CriticalSectionGroup tnGroup = ig.groups().get(group + 1);
            if (tnGroup.size() <= 0) continue;
            logger.debug("Group " + (group + 1) + " ");
            logger.debug("Locking: " + (tnGroup.useLocksets ? "using " : (tnGroup.isDynamicLock && tnGroup.useDynamicLock ? "Dynamic on " : "Static on ")) + (tnGroup.useLocksets ? "locksets" : (tnGroup.lockObject == null ? "null" : tnGroup.lockObject.toString())));
            logger.debug("\n[transaction-groups]      : ");
            for (CriticalSection tn : AllTransactions) {
                if (tn.setNumber != group + 1) continue;
                logger.debug(tn.name + " ");
            }
            logger.debug("\n[transaction-groups] " + tnGroup.rwSet.toString().replaceAll("\\[", "     : [").replaceAll("\n", "\n[transaction-groups] "));
        }
        logger.debug("Erasing \n[transaction-groups]      : ");
        for (CriticalSection tn : AllTransactions) {
            if (tn.setNumber != -1) continue;
            logger.debug(tn.name + " ");
        }
        logger.debug("\n[transaction-groups] ");
    }

    public CriticalSectionInterferenceGraph getInterferenceGraph() {
        return this.interferenceGraph;
    }

    public DirectedGraph getDeadlockGraph() {
        return this.deadlockGraph;
    }

    public List<CriticalSection> getCriticalSections() {
        return this.criticalSections;
    }
}

