/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.thread.mhp;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import soot.jimple.toolkits.thread.mhp.DominatorsFinder;
import soot.jimple.toolkits.thread.mhp.stmt.JPegStmt;
import soot.tagkit.Tag;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.scalar.FlowSet;
import soot.util.Chain;

public class DfsForBackEdge {
    private final Map<Object, Object> backEdges = new HashMap<Object, Object>();
    private final Set<Object> gray = new HashSet<Object>();
    private final Set<Object> black = new HashSet<Object>();
    private final DominatorsFinder domFinder;

    DfsForBackEdge(Chain chain, DirectedGraph peg) {
        this.domFinder = new DominatorsFinder(chain, peg);
        Iterator it = chain.iterator();
        this.dfs(it, peg);
        this.testBackEdge();
    }

    private void dfs(Iterator it, DirectedGraph g2) {
        while (it.hasNext()) {
            Object s2 = it.next();
            if (this.gray.contains(s2)) continue;
            this.visitNode(g2, s2);
        }
    }

    private void visitNode(DirectedGraph g2, Object s2) {
        this.gray.add(s2);
        Iterator<Object> it = g2.getSuccsOf(s2).iterator();
        if (g2.getSuccsOf(s2).size() > 0) {
            while (it.hasNext()) {
                FlowSet dominators;
                Object succ = it.next();
                if (!this.gray.contains(succ)) {
                    this.visitNode(g2, succ);
                    continue;
                }
                if (!this.gray.contains(succ) || this.black.contains(succ) || !(dominators = this.domFinder.getDominatorsOf(s2)).contains(succ)) continue;
                System.out.println("s is " + s2);
                System.out.println("succ is " + succ);
                this.backEdges.put(s2, succ);
            }
        }
        this.black.add(s2);
    }

    protected Map<Object, Object> getBackEdges() {
        return this.backEdges;
    }

    private void testBackEdge() {
        System.out.println("===test backEdges==");
        Set<Map.Entry<Object, Object>> maps = this.backEdges.entrySet();
        for (Map.Entry<Object, Object> entry : maps) {
            JPegStmt key = (JPegStmt)entry.getKey();
            Tag tag = key.getTags().get(0);
            System.out.println("---key=  " + tag + " " + key);
            JPegStmt value = (JPegStmt)entry.getValue();
            Tag tag1 = value.getTags().get(0);
            System.out.println("---value=  " + tag1 + " " + value);
        }
        System.out.println("===test backEdges==end==");
    }
}

