/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.PhaseOptions;
import soot.Scene;
import soot.Singletons;
import soot.Trap;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.options.Options;
import soot.toolkits.exceptions.PedanticThrowAnalysis;
import soot.toolkits.exceptions.ThrowAnalysis;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.graph.ExceptionalUnitGraphFactory;
import soot.util.Chain;

public class UnreachableCodeEliminator
extends BodyTransformer {
    private static final Logger logger = LoggerFactory.getLogger(UnreachableCodeEliminator.class);
    protected ThrowAnalysis throwAnalysis = null;

    public static UnreachableCodeEliminator v() {
        return G.v().soot_jimple_toolkits_scalar_UnreachableCodeEliminator();
    }

    public UnreachableCodeEliminator(Singletons.Global g2) {
    }

    public UnreachableCodeEliminator(ThrowAnalysis ta) {
        this.throwAnalysis = ta;
    }

    @Override
    protected void internalTransform(Body body, String phaseName, Map<String, String> options) {
        UnitPatchingChain units;
        int origSize;
        boolean verbose = Options.v().verbose();
        if (verbose) {
            logger.debug("[" + body.getMethod().getName() + "] Eliminating unreachable code...");
        }
        if (this.throwAnalysis == null) {
            boolean opt = PhaseOptions.getBoolean(options, "remove-unreachable-traps", true);
            this.throwAnalysis = opt ? Scene.v().getDefaultThrowAnalysis() : PedanticThrowAnalysis.v();
        }
        Set reachable = (origSize = (units = body.getUnits()).size()) == 0 ? Collections.emptySet() : this.reachable((Unit)units.getFirst(), ExceptionalUnitGraphFactory.createExceptionalUnitGraph(body, this.throwAnalysis, false));
        Chain<Trap> traps = body.getTraps();
        Iterator<Trap> it = traps.iterator();
        while (it.hasNext()) {
            Trap trap = it.next();
            if (trap.getBeginUnit() != trap.getEndUnit() && reachable.contains(trap.getHandlerUnit())) continue;
            it.remove();
        }
        Unit lastUnit = (Unit)units.getLast();
        for (Trap t2 : traps) {
            if (t2.getEndUnit() != lastUnit) continue;
            reachable.add(lastUnit);
            break;
        }
        HashSet<Unit> notReachable = null;
        for (Unit u : units) {
            if (reachable.contains(u)) continue;
            if (verbose) {
                if (notReachable == null) {
                    notReachable = new HashSet<Unit>();
                }
                notReachable.add(u);
            }
            if (!Scene.v().hasCallGraph()) continue;
            Scene.v().getCallGraph().removeAllEdgesOutOf(u);
        }
        units.retainAll(reachable);
        if (verbose) {
            String name = body.getMethod().getName();
            logger.debug("[" + name + "]\t Removed " + (origSize - units.size()) + " statements: ");
            if (notReachable != null) {
                for (Unit u : notReachable) {
                    logger.debug("[" + name + "]\t         " + u);
                }
            }
        }
    }

    private <T> Set<T> reachable(T first, DirectedGraph<T> g2) {
        if (first == null || g2 == null) {
            return Collections.emptySet();
        }
        HashSet visited = new HashSet(g2.size());
        ArrayDeque<T> q = new ArrayDeque<T>();
        q.addFirst(first);
        do {
            Object t2;
            if (!visited.add(t2 = q.removeFirst())) continue;
            q.addAll(g2.getSuccsOf(t2));
        } while (!q.isEmpty());
        return visited;
    }
}

