/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar;

import java.util.Iterator;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.DoubleType;
import soot.FloatType;
import soot.G;
import soot.IntType;
import soot.LongType;
import soot.Singletons;
import soot.Type;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.Value;
import soot.jimple.AddExpr;
import soot.jimple.AssignStmt;
import soot.jimple.BinopExpr;
import soot.jimple.DoubleConstant;
import soot.jimple.FloatConstant;
import soot.jimple.IntConstant;
import soot.jimple.LongConstant;
import soot.jimple.MulExpr;
import soot.jimple.OrExpr;
import soot.jimple.SubExpr;

public class IdentityOperationEliminator
extends BodyTransformer {
    public IdentityOperationEliminator(Singletons.Global g2) {
    }

    public static IdentityOperationEliminator v() {
        return G.v().soot_jimple_toolkits_scalar_IdentityOperationEliminator();
    }

    @Override
    protected void internalTransform(Body b, String phaseName, Map<String, String> options) {
        AssignStmt assignStmt;
        UnitPatchingChain units = b.getUnits();
        for (Unit u : units) {
            BinopExpr aer;
            if (!(u instanceof AssignStmt)) continue;
            assignStmt = (AssignStmt)u;
            Value rightOp = assignStmt.getRightOp();
            if (rightOp instanceof AddExpr) {
                aer = (BinopExpr)rightOp;
                if (IdentityOperationEliminator.isConstZero(aer.getOp1())) {
                    assignStmt.setRightOp(aer.getOp2());
                    continue;
                }
                if (!IdentityOperationEliminator.isConstZero(aer.getOp2())) continue;
                assignStmt.setRightOp(aer.getOp1());
                continue;
            }
            if (rightOp instanceof SubExpr) {
                aer = (BinopExpr)rightOp;
                if (!IdentityOperationEliminator.isConstZero(aer.getOp2())) continue;
                assignStmt.setRightOp(aer.getOp1());
                continue;
            }
            if (rightOp instanceof MulExpr) {
                aer = (BinopExpr)rightOp;
                if (IdentityOperationEliminator.isConstZero(aer.getOp1())) {
                    assignStmt.setRightOp(IdentityOperationEliminator.getZeroConst(assignStmt.getLeftOp().getType()));
                    continue;
                }
                if (!IdentityOperationEliminator.isConstZero(aer.getOp2())) continue;
                assignStmt.setRightOp(IdentityOperationEliminator.getZeroConst(assignStmt.getLeftOp().getType()));
                continue;
            }
            if (!(rightOp instanceof OrExpr)) continue;
            OrExpr orExpr = (OrExpr)rightOp;
            if (IdentityOperationEliminator.isConstZero(orExpr.getOp1())) {
                assignStmt.setRightOp(orExpr.getOp2());
                continue;
            }
            if (!IdentityOperationEliminator.isConstZero(orExpr.getOp2())) continue;
            assignStmt.setRightOp(orExpr.getOp1());
        }
        Iterator unitIt = units.iterator();
        while (unitIt.hasNext()) {
            Unit u;
            u = (Unit)unitIt.next();
            if (!(u instanceof AssignStmt) || (assignStmt = (AssignStmt)u).getLeftOp() != assignStmt.getRightOp()) continue;
            unitIt.remove();
        }
    }

    private static Value getZeroConst(Type type) {
        if (type instanceof IntType) {
            return IntConstant.v(0);
        }
        if (type instanceof LongType) {
            return LongConstant.v(0L);
        }
        if (type instanceof FloatType) {
            return FloatConstant.v(0.0f);
        }
        if (type instanceof DoubleType) {
            return DoubleConstant.v(0.0);
        }
        throw new RuntimeException("Unsupported numeric type");
    }

    private static boolean isConstZero(Value op) {
        return op instanceof IntConstant && ((IntConstant)op).value == 0;
    }
}

