/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar;

import java.util.ArrayList;
import java.util.List;
import soot.EquivalentValue;
import soot.Local;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.DefinitionStmt;
import soot.jimple.IdentityStmt;
import soot.jimple.Stmt;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.ArraySparseSet;
import soot.toolkits.scalar.FlowSet;
import soot.toolkits.scalar.ForwardFlowAnalysis;

public class EqualLocalsAnalysis
extends ForwardFlowAnalysis<Unit, FlowSet<Object>> {
    protected Local l = null;
    protected Stmt s = null;

    public EqualLocalsAnalysis(UnitGraph g2) {
        super(g2);
    }

    public List<Object> getCopiesOfAt(Local l, Stmt s2) {
        this.l = l;
        this.s = s2;
        this.doAnalysis();
        FlowSet fs = (FlowSet)this.getFlowBefore(s2);
        ArrayList<Object> aliasList = new ArrayList<Object>(fs.size());
        for (Object o : fs) {
            aliasList.add(o);
        }
        if (!aliasList.contains(new EquivalentValue(l))) {
            aliasList.clear();
            aliasList.trimToSize();
        }
        return aliasList;
    }

    @Override
    protected void flowThrough(FlowSet<Object> in, Unit unit, FlowSet<Object> out) {
        in.copy(out);
        ArrayList<EquivalentValue> newDefs = new ArrayList<EquivalentValue>();
        for (ValueBox valueBox : unit.getDefBoxes()) {
            newDefs.add(new EquivalentValue(valueBox.getValue()));
        }
        if (newDefs.contains(new EquivalentValue(this.l))) {
            DefinitionStmt definitionStmt;
            ArrayList<Stmt> existingDefStmts = new ArrayList<Stmt>();
            for (Object object : out) {
                if (!(object instanceof Stmt)) continue;
                existingDefStmts.add((Stmt)object);
            }
            out.clear();
            for (EquivalentValue equivalentValue : newDefs) {
                out.add(equivalentValue);
            }
            if (unit instanceof DefinitionStmt && !(definitionStmt = (DefinitionStmt)unit).containsInvokeExpr() && !(unit instanceof IdentityStmt)) {
                out.add(new EquivalentValue(definitionStmt.getRightOp()));
            }
            for (Stmt stmt : existingDefStmts) {
                ArrayList<Value> sNewDefs = new ArrayList<Value>();
                for (ValueBox next : stmt.getDefBoxes()) {
                    sNewDefs.add(next.getValue());
                }
                if (!(stmt instanceof DefinitionStmt)) continue;
                if (out.contains(new EquivalentValue(((DefinitionStmt)stmt).getRightOp()))) {
                    for (Value v : sNewDefs) {
                        out.add(new EquivalentValue(v));
                    }
                    continue;
                }
                for (Value v : sNewDefs) {
                    out.remove(new EquivalentValue(v));
                }
            }
        } else if (unit instanceof DefinitionStmt) {
            if (out.contains(new EquivalentValue(this.l))) {
                if (out.contains(new EquivalentValue(((DefinitionStmt)unit).getRightOp()))) {
                    for (EquivalentValue equivalentValue : newDefs) {
                        out.add(equivalentValue);
                    }
                } else {
                    for (EquivalentValue equivalentValue : newDefs) {
                        out.remove(equivalentValue);
                    }
                }
            } else {
                out.add(unit);
            }
        }
    }

    @Override
    protected void merge(FlowSet<Object> in1, FlowSet<Object> in2, FlowSet<Object> out) {
        in1.intersection(in2, out);
    }

    @Override
    protected void copy(FlowSet<Object> source, FlowSet<Object> dest) {
        source.copy(dest);
    }

    @Override
    protected FlowSet<Object> entryInitialFlow() {
        return new ArraySparseSet<Object>();
    }

    @Override
    protected FlowSet<Object> newInitialFlow() {
        return new ArraySparseSet<Object>();
    }
}

