/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.Local;
import soot.NullType;
import soot.RefLikeType;
import soot.Scene;
import soot.Singletons;
import soot.Timers;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.AssignStmt;
import soot.jimple.CastExpr;
import soot.jimple.Constant;
import soot.jimple.DefinitionStmt;
import soot.jimple.IntConstant;
import soot.jimple.LongConstant;
import soot.jimple.NullConstant;
import soot.jimple.Stmt;
import soot.options.CPOptions;
import soot.options.Options;
import soot.tagkit.Host;
import soot.tagkit.Tag;
import soot.toolkits.exceptions.ThrowAnalysis;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.graph.ExceptionalUnitGraphFactory;
import soot.toolkits.graph.PseudoTopologicalOrderer;
import soot.toolkits.scalar.LocalDefs;

public class CopyPropagator
extends BodyTransformer {
    private static final Logger logger = LoggerFactory.getLogger(CopyPropagator.class);
    protected ThrowAnalysis throwAnalysis = null;
    protected boolean forceOmitExceptingUnitEdges = false;

    public CopyPropagator(Singletons.Global g2) {
    }

    public CopyPropagator(ThrowAnalysis ta) {
        this.throwAnalysis = ta;
    }

    public CopyPropagator(ThrowAnalysis ta, boolean forceOmitExceptingUnitEdges) {
        this.throwAnalysis = ta;
        this.forceOmitExceptingUnitEdges = forceOmitExceptingUnitEdges;
    }

    public static CopyPropagator v() {
        return G.v().soot_jimple_toolkits_scalar_CopyPropagator();
    }

    @Override
    protected void internalTransform(Body b, String phaseName, Map<String, String> opts) {
        if (Options.v().verbose()) {
            logger.debug("[" + b.getMethod().getName() + "] Propagating copies...");
        }
        if (Options.v().time()) {
            Timers.v().propagatorTimer.start();
        }
        HashMap<Local, Integer> localToDefCount = new HashMap<Local, Integer>(b.getLocalCount() * 2 + 1);
        for (Unit u : b.getUnits()) {
            Local loc;
            Value leftOp;
            if (!(u instanceof DefinitionStmt) || !((leftOp = ((DefinitionStmt)u).getLeftOp()) instanceof Local)) continue;
            Integer old = (Integer)localToDefCount.get(loc = (Local)leftOp);
            localToDefCount.put(loc, old == null ? 1 : old + 1);
        }
        if (this.throwAnalysis == null) {
            this.throwAnalysis = Scene.v().getDefaultThrowAnalysis();
        }
        if (!this.forceOmitExceptingUnitEdges) {
            this.forceOmitExceptingUnitEdges = Options.v().omit_excepting_unit_edges();
        }
        int fastCopyPropagationCount = 0;
        int slowCopyPropagationCount = 0;
        ExceptionalUnitGraph graph = ExceptionalUnitGraphFactory.createExceptionalUnitGraph(b, this.throwAnalysis, this.forceOmitExceptingUnitEdges);
        LocalDefs localDefs = G.v().soot_toolkits_scalar_LocalDefsFactory().newLocalDefs(graph);
        CPOptions options = new CPOptions(opts);
        boolean onlyRegularLocals = options.only_regular_locals();
        boolean onlyStackLocals = options.only_stack_locals();
        boolean allLocals = onlyRegularLocals && onlyStackLocals;
        boolean isDotNet = Options.v().src_prec() == 7;
        for (Unit u : new PseudoTopologicalOrderer<Unit>().newList(graph, false)) {
            for (ValueBox useBox : u.getUseBoxes()) {
                Stmt s2;
                Local m4;
                boolean propagateDef;
                Value value = useBox.getValue();
                if (!(value instanceof Local)) continue;
                Local l = (Local)value;
                if (!allLocals && !(l.getType() instanceof NullType) && (onlyRegularLocals && l.isStackLocal() || onlyStackLocals && !l.isStackLocal())) continue;
                List<Unit> defsOfUse = localDefs.getDefsOfAt(l, u);
                boolean bl = propagateDef = defsOfUse.size() == 1;
                if (!propagateDef && defsOfUse.size() > 0) {
                    boolean agrees = true;
                    Constant constVal = null;
                    for (Unit defUnit : defsOfUse) {
                        Value rightOp;
                        boolean defAgrees = false;
                        if (defUnit instanceof AssignStmt && (rightOp = ((AssignStmt)defUnit).getRightOp()) instanceof Constant) {
                            if (constVal == null) {
                                constVal = (Constant)rightOp;
                                defAgrees = true;
                            } else if (constVal.equals(rightOp)) {
                                defAgrees = true;
                            }
                        }
                        agrees &= defAgrees;
                    }
                    propagateDef = agrees;
                }
                if (!propagateDef) continue;
                DefinitionStmt def = (DefinitionStmt)defsOfUse.get(0);
                Value rightOp = def.getRightOp();
                if (rightOp instanceof Constant) {
                    if (!useBox.canContainValue(rightOp)) continue;
                    useBox.setValue(rightOp);
                    CopyPropagator.copyLineTags(useBox, def);
                    continue;
                }
                if (rightOp instanceof CastExpr) {
                    Value op;
                    CastExpr ce = (CastExpr)rightOp;
                    if (!(ce.getCastType() instanceof RefLikeType) || (!((op = ce.getOp()) instanceof IntConstant) || ((IntConstant)op).value != 0) && (!(op instanceof LongConstant) || ((LongConstant)op).value != 0L) || !useBox.canContainValue(NullConstant.v()) || isDotNet) continue;
                    useBox.setValue(NullConstant.v());
                    CopyPropagator.copyLineTags(useBox, def);
                    continue;
                }
                if (!(rightOp instanceof Local) || l == (m4 = (Local)rightOp)) continue;
                Integer defCount = (Integer)localToDefCount.get(m4);
                if (defCount == null || defCount == 0) {
                    throw new RuntimeException("Variable " + m4 + " used without definition!");
                }
                if (defCount == 1) {
                    useBox.setValue(m4);
                    CopyPropagator.copyLineTags(useBox, def);
                    ++fastCopyPropagationCount;
                    continue;
                }
                List<Unit> path = graph.getExtendedBasicBlockPathBetween(def, u);
                if (path == null) continue;
                boolean isRedefined = false;
                Iterator<Unit> pathIt = path.iterator();
                pathIt.next();
                while (pathIt.hasNext() && u != (s2 = (Stmt)pathIt.next())) {
                    if (!(s2 instanceof DefinitionStmt) || ((DefinitionStmt)s2).getLeftOp() != m4) continue;
                    isRedefined = true;
                    break;
                }
                if (isRedefined) continue;
                useBox.setValue(m4);
                ++slowCopyPropagationCount;
            }
        }
        if (Options.v().verbose()) {
            logger.debug("[" + b.getMethod().getName() + "]     Propagated: " + fastCopyPropagationCount + " fast copies  " + slowCopyPropagationCount + " slow copies");
        }
        if (Options.v().time()) {
            Timers.v().propagatorTimer.end();
        }
    }

    public static void copyLineTags(ValueBox useBox, DefinitionStmt def) {
        if (!CopyPropagator.copyLineTags(useBox, def.getRightOpBox())) {
            CopyPropagator.copyLineTags(useBox, (Host)def);
        }
    }

    private static boolean copyLineTags(ValueBox useBox, Host host) {
        boolean res = false;
        Tag tag = host.getTag("SourceLnPosTag");
        if (tag != null) {
            useBox.addTag(tag);
            res = true;
        }
        if ((tag = host.getTag("LineNumberTag")) != null) {
            useBox.addTag(tag);
            res = true;
        }
        return res;
    }
}

