/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.pointer;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import soot.G;
import soot.Local;
import soot.MethodOrMethodContext;
import soot.PointsToAnalysis;
import soot.PointsToSet;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.Filter;
import soot.jimple.toolkits.callgraph.TransitiveTargets;
import soot.jimple.toolkits.pointer.FullObjectSet;
import soot.jimple.toolkits.pointer.MethodRWSet;
import soot.jimple.toolkits.pointer.RWSet;
import soot.jimple.toolkits.pointer.SiteRWSet;
import soot.jimple.toolkits.pointer.StmtRWSet;
import soot.jimple.toolkits.pointer.Union;
import soot.jimple.toolkits.pointer.UnionFactory;

public class SideEffectAnalysis {
    private final Map<SootMethod, MethodRWSet> methodToNTReadSet = new HashMap<SootMethod, MethodRWSet>();
    private final Map<SootMethod, MethodRWSet> methodToNTWriteSet = new HashMap<SootMethod, MethodRWSet>();
    private final PointsToAnalysis pa;
    private final CallGraph cg;
    private final TransitiveTargets tt;

    private SideEffectAnalysis(PointsToAnalysis pa, CallGraph cg, TransitiveTargets tt) {
        if (G.v().Union_factory == null) {
            G.v().Union_factory = new UnionFactory(){

                @Override
                public Union newUnion() {
                    return FullObjectSet.v();
                }
            };
        }
        this.pa = pa;
        this.cg = cg;
        this.tt = tt;
    }

    public SideEffectAnalysis(PointsToAnalysis pa, CallGraph cg) {
        this(pa, cg, new TransitiveTargets(cg));
    }

    public SideEffectAnalysis(PointsToAnalysis pa, CallGraph cg, Filter filter) {
        this(pa, cg, new TransitiveTargets(cg, filter));
    }

    public void findNTRWSets(SootMethod method) {
        if (this.methodToNTReadSet.containsKey(method) && this.methodToNTWriteSet.containsKey(method)) {
            return;
        }
        MethodRWSet read = null;
        MethodRWSet write = null;
        for (Unit next : method.retrieveActiveBody().getUnits()) {
            RWSet ntw;
            Stmt s2 = (Stmt)next;
            RWSet ntr = this.ntReadSet(method, s2);
            if (ntr != null) {
                if (read == null) {
                    read = new MethodRWSet();
                }
                read.union(ntr);
            }
            if ((ntw = this.ntWriteSet(method, s2)) == null) continue;
            if (write == null) {
                write = new MethodRWSet();
            }
            write.union(ntw);
        }
        this.methodToNTReadSet.put(method, read);
        this.methodToNTWriteSet.put(method, write);
    }

    public RWSet nonTransitiveReadSet(SootMethod method) {
        this.findNTRWSets(method);
        return this.methodToNTReadSet.get(method);
    }

    public RWSet nonTransitiveWriteSet(SootMethod method) {
        this.findNTRWSets(method);
        return this.methodToNTWriteSet.get(method);
    }

    private RWSet ntReadSet(SootMethod method, Stmt stmt) {
        if (stmt instanceof AssignStmt) {
            return this.addValue(((AssignStmt)stmt).getRightOp(), method, stmt);
        }
        return null;
    }

    public RWSet readSet(SootMethod method, Stmt stmt) {
        RWSet ret = null;
        Iterator<MethodOrMethodContext> targets = this.tt.iterator(stmt);
        while (targets.hasNext()) {
            RWSet ntr;
            SootMethod target = (SootMethod)targets.next();
            if (target.isNative()) {
                if (ret == null) {
                    ret = new SiteRWSet();
                }
                ret.setCallsNative();
                continue;
            }
            if (!target.isConcrete() || (ntr = this.nonTransitiveReadSet(target)) == null) continue;
            if (ret == null) {
                ret = new SiteRWSet();
            }
            ret.union(ntr);
        }
        if (ret == null) {
            return this.ntReadSet(method, stmt);
        }
        ret.union(this.ntReadSet(method, stmt));
        return ret;
    }

    private RWSet ntWriteSet(SootMethod method, Stmt stmt) {
        if (stmt instanceof AssignStmt) {
            return this.addValue(((AssignStmt)stmt).getLeftOp(), method, stmt);
        }
        return null;
    }

    public RWSet writeSet(SootMethod method, Stmt stmt) {
        RWSet ret = null;
        Iterator<MethodOrMethodContext> targets = this.tt.iterator(stmt);
        while (targets.hasNext()) {
            RWSet ntw;
            SootMethod target = (SootMethod)targets.next();
            if (target.isNative()) {
                if (ret == null) {
                    ret = new SiteRWSet();
                }
                ret.setCallsNative();
                continue;
            }
            if (!target.isConcrete() || (ntw = this.nonTransitiveWriteSet(target)) == null) continue;
            if (ret == null) {
                ret = new SiteRWSet();
            }
            ret.union(ntw);
        }
        if (ret == null) {
            return this.ntWriteSet(method, stmt);
        }
        ret.union(this.ntWriteSet(method, stmt));
        return ret;
    }

    protected RWSet addValue(Value v, SootMethod m4, Stmt s2) {
        StmtRWSet ret = null;
        if (v instanceof InstanceFieldRef) {
            InstanceFieldRef ifr = (InstanceFieldRef)v;
            PointsToSet base = this.pa.reachingObjects((Local)ifr.getBase());
            ret = new StmtRWSet();
            ((RWSet)ret).addFieldRef(base, ifr.getField());
        } else if (v instanceof StaticFieldRef) {
            StaticFieldRef sfr = (StaticFieldRef)v;
            ret = new StmtRWSet();
            ((RWSet)ret).addGlobal(sfr.getField());
        } else if (v instanceof ArrayRef) {
            ArrayRef ar = (ArrayRef)v;
            PointsToSet base = this.pa.reachingObjects((Local)ar.getBase());
            ret = new StmtRWSet();
            ((RWSet)ret).addFieldRef(base, "ARRAY_ELEMENTS_NODE");
        }
        return ret;
    }

    public String toString() {
        return "SideEffectAnalysis: PA=" + this.pa + " CG=" + this.cg;
    }
}

