/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.invoke;

import java.util.Iterator;
import java.util.Set;
import soot.Body;
import soot.Hierarchy;
import soot.Local;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.Trap;
import soot.TrapManager;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.Constant;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.NewExpr;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.ThrowStmt;
import soot.shimple.ShimpleBody;
import soot.util.Chain;

public class ThrowManager {
    public static Stmt getNullPointerExceptionThrower(JimpleBody b) {
        return ThrowManager.getNullPointerExceptionThrower((Body)b);
    }

    public static Stmt getNullPointerExceptionThrower(ShimpleBody b) {
        return ThrowManager.getNullPointerExceptionThrower((Body)b);
    }

    static Stmt getNullPointerExceptionThrower(Body b) {
        Stmt last;
        assert (b instanceof JimpleBody || b instanceof ShimpleBody);
        Set<Unit> trappedUnits = TrapManager.getTrappedUnitsOf(b);
        UnitPatchingChain units = b.getUnits();
        Unit first = (Unit)units.getFirst();
        Stmt s2 = last = (Stmt)units.getLast();
        while (s2 != first) {
            Value throwee;
            if (!trappedUnits.contains(s2) && s2 instanceof ThrowStmt && !((throwee = ((ThrowStmt)s2).getOp()) instanceof Constant)) {
                if (s2 == first) break;
                Stmt prosInvoke = units.getPredOf(s2);
                if (prosInvoke instanceof InvokeStmt) {
                    InvokeExpr ie;
                    if (prosInvoke == first) break;
                    Stmt prosNew = units.getPredOf(prosInvoke);
                    if (prosNew instanceof AssignStmt && (ie = ((InvokeStmt)prosInvoke).getInvokeExpr()) instanceof SpecialInvokeExpr && ((SpecialInvokeExpr)ie).getBase() == throwee && "<init>".equals(ie.getMethodRef().name())) {
                        Value ro = ((AssignStmt)prosNew).getRightOp();
                        if (((AssignStmt)prosNew).getLeftOp() == throwee && ro instanceof NewExpr && ((NewExpr)ro).getBaseType().equals(RefType.v("java.lang.NullPointerException"))) {
                            return prosNew;
                        }
                    }
                }
            }
            s2 = units.getPredOf(s2);
        }
        return ThrowManager.addThrowAfter(b.getLocals(), units, last);
    }

    static Stmt addThrowAfter(JimpleBody b, Stmt target) {
        return ThrowManager.addThrowAfter(b.getLocals(), b.getUnits(), target);
    }

    static Stmt addThrowAfter(ShimpleBody b, Stmt target) {
        return ThrowManager.addThrowAfter(b.getLocals(), b.getUnits(), target);
    }

    static Stmt addThrowAfter(Chain<Local> locals, Chain<Unit> units, Stmt target) {
        boolean canAddI;
        int i = 0;
        do {
            canAddI = true;
            String name = "__throwee" + i;
            for (Local l : locals) {
                if (!name.equals(l.getName())) continue;
                canAddI = false;
            }
            if (canAddI) continue;
            ++i;
        } while (!canAddI);
        Jimple jimp = Jimple.v();
        Local l = jimp.newLocal("__throwee" + i, RefType.v("java.lang.NullPointerException"));
        locals.add(l);
        AssignStmt newStmt = jimp.newAssignStmt(l, jimp.newNewExpr(RefType.v("java.lang.NullPointerException")));
        InvokeStmt invStmt = jimp.newInvokeStmt(jimp.newSpecialInvokeExpr(l, Scene.v().getMethod("<java.lang.NullPointerException: void <init>()>").makeRef()));
        ThrowStmt throwStmt = jimp.newThrowStmt(l);
        units.insertAfter(newStmt, (Unit)target);
        units.insertAfter(invStmt, (Unit)newStmt);
        units.insertAfter(throwStmt, (Unit)invStmt);
        return newStmt;
    }

    static boolean isExceptionCaughtAt(SootClass e, Stmt stmt, Body b) {
        Hierarchy h2 = new Hierarchy();
        for (Trap t2 : b.getTraps()) {
            if (!h2.isClassSubclassOfIncluding(e, t2.getException())) continue;
            Iterator<Unit> it = b.getUnits().iterator(t2.getBeginUnit(), t2.getEndUnit());
            while (it.hasNext()) {
                if (!stmt.equals(it.next())) continue;
                return true;
            }
        }
        return false;
    }
}

