/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.invoke;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import soot.Body;
import soot.G;
import soot.Local;
import soot.RefType;
import soot.Scene;
import soot.Singletons;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.ExitMonitorStmt;
import soot.jimple.GotoStmt;
import soot.jimple.IdentityStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.NullConstant;
import soot.jimple.ParameterRef;
import soot.jimple.ReturnStmt;
import soot.jimple.Stmt;
import soot.jimple.StmtBody;
import soot.jimple.StringConstant;
import soot.shimple.Shimple;
import soot.shimple.ShimpleBody;
import soot.util.Chain;

public class SynchronizerManager {
    public HashMap<SootClass, SootField> classToClassField = new HashMap();

    public SynchronizerManager(Singletons.Global g2) {
    }

    public static SynchronizerManager v() {
        return G.v().soot_jimple_toolkits_invoke_SynchronizerManager();
    }

    public Local addStmtsToFetchClassBefore(JimpleBody b, Stmt target) {
        return this.addStmtsToFetchClassBefore(b, target, false);
    }

    public Local addStmtsToFetchClassBefore(ShimpleBody b, Stmt target) {
        return this.addStmtsToFetchClassBefore(b, target, true);
    }

    Local addStmtsToFetchClassBefore(Body b, Stmt target) {
        assert (b instanceof JimpleBody || b instanceof ShimpleBody);
        return this.addStmtsToFetchClassBefore(b, target, b instanceof ShimpleBody);
    }

    private Local addStmtsToFetchClassBefore(Body b, Stmt target, boolean createNewAsShimple) {
        SootClass sc = b.getMethod().getDeclaringClass();
        SootField classCacher = this.classToClassField.get(sc);
        if (classCacher == null) {
            String n = "class$" + sc.getName().replace('.', '$');
            while (sc.declaresFieldByName(n)) {
                n = "_" + n;
            }
            classCacher = Scene.v().makeSootField(n, RefType.v("java.lang.Class"), 8);
            sc.addField(classCacher);
            this.classToClassField.put(sc, classCacher);
        }
        Chain<Local> locals = b.getLocals();
        Object lName = "$uniqueClass";
        while (true) {
            boolean oops = false;
            for (Local jbLocal : locals) {
                if (!((String)lName).equals(jbLocal.getName())) continue;
                oops = true;
            }
            if (!oops) break;
            lName = "_" + (String)lName;
        }
        Jimple jimp = Jimple.v();
        Local l = jimp.newLocal((String)lName, RefType.v("java.lang.Class"));
        locals.add(l);
        UnitPatchingChain units = b.getUnits();
        units.insertBefore(jimp.newAssignStmt(l, jimp.newStaticFieldRef(classCacher.makeRef())), target);
        units.insertBefore(jimp.newIfStmt((Value)jimp.newNeExpr(l, NullConstant.v()), target), target);
        units.insertBefore(jimp.newAssignStmt(l, jimp.newStaticInvokeExpr(this.getClassFetcherFor(sc, createNewAsShimple).makeRef(), Collections.singletonList(StringConstant.v(sc.getName())))), target);
        units.insertBefore(jimp.newAssignStmt(jimp.newStaticFieldRef(classCacher.makeRef()), l), target);
        return l;
    }

    public SootMethod getClassFetcherFor(SootClass c) {
        return this.getClassFetcherFor(c, false);
    }

    public SootMethod getClassFetcherFor(SootClass c, boolean createNewAsShimple) {
        String prefix = "<" + c.getName().replace('.', '$') + ": java.lang.Class ";
        Object methodName = "class$";
        SootMethod m4;
        while ((m4 = c.getMethodByNameUnsafe((String)methodName)) != null) {
            IdentityStmt is;
            Value ro;
            Stmt s2;
            Iterator unitsIt;
            if ((prefix + (String)methodName + "(java.lang.String)>").equals(m4.getSignature()) && (unitsIt = m4.retrieveActiveBody().getUnits().iterator()).hasNext() && (s2 = (Stmt)unitsIt.next()) instanceof IdentityStmt && (ro = (is = (IdentityStmt)s2).getRightOp()) instanceof ParameterRef && ((ParameterRef)ro).getIndex() == 0 && unitsIt.hasNext() && (s2 = (Stmt)unitsIt.next()) instanceof AssignStmt) {
                AssignStmt as = (AssignStmt)s2;
                if ((".staticinvoke <java.lang.Class: java.lang.Class forName(java.lang.String)>(" + is.getLeftOp() + ")").equals(as.getRightOp().toString()) && unitsIt.hasNext() && (s2 = (Stmt)unitsIt.next()) instanceof ReturnStmt && ((ReturnStmt)s2).getOp().equivTo(as.getLeftOp())) {
                    return m4;
                }
            }
            methodName = "_" + (String)methodName;
        }
        return this.createClassFetcherFor(c, (String)methodName, createNewAsShimple);
    }

    public SootMethod createClassFetcherFor(SootClass c, String methodName) {
        return this.createClassFetcherFor(c, methodName, false);
    }

    public SootMethod createClassFetcherFor(SootClass c, String methodName, boolean createNewAsShimple) {
        RefType refTyString = RefType.v("java.lang.String");
        RefType refTypeClass = RefType.v("java.lang.Class");
        Scene scene = Scene.v();
        SootMethod method = scene.makeSootMethod(methodName, Collections.singletonList(refTyString), refTypeClass, 8);
        c.addMethod(method);
        Jimple jimp = Jimple.v();
        StmtBody body = jimp.newBody(method);
        RefType refTypeClassNotFoundException = RefType.v("java.lang.ClassNotFoundException");
        RefType refTypeNoClassDefFoundError = RefType.v("java.lang.NoClassDefFoundError");
        Chain<Local> locals = body.getLocals();
        Local l_r0 = jimp.newLocal("r0", refTyString);
        locals.add(l_r0);
        Local l_r1 = jimp.newLocal("r1", refTypeClassNotFoundException);
        locals.add(l_r1);
        Local l_r2 = jimp.newLocal("$r2", refTypeClass);
        locals.add(l_r2);
        Local l_r3 = jimp.newLocal("$r3", refTypeClassNotFoundException);
        locals.add(l_r3);
        Local l_r4 = jimp.newLocal("$r4", refTypeNoClassDefFoundError);
        locals.add(l_r4);
        Local l_r5 = jimp.newLocal("$r5", refTyString);
        locals.add(l_r5);
        UnitPatchingChain units = body.getUnits();
        units.add(jimp.newIdentityStmt(l_r0, jimp.newParameterRef(refTyString, 0)));
        AssignStmt asi = jimp.newAssignStmt(l_r2, jimp.newStaticInvokeExpr(scene.getMethod("<java.lang.Class: java.lang.Class forName(java.lang.String)>").makeRef(), Collections.singletonList(l_r0)));
        units.add(asi);
        units.add(jimp.newReturnStmt(l_r2));
        IdentityStmt handlerStart = jimp.newIdentityStmt(l_r3, jimp.newCaughtExceptionRef());
        units.add(handlerStart);
        units.add(jimp.newAssignStmt(l_r1, l_r3));
        units.add(jimp.newAssignStmt(l_r4, jimp.newNewExpr(refTypeNoClassDefFoundError)));
        units.add(jimp.newAssignStmt(l_r5, jimp.newVirtualInvokeExpr(l_r1, scene.getMethod("<java.lang.Throwable: java.lang.String getMessage()>").makeRef(), Collections.emptyList())));
        units.add(jimp.newInvokeStmt(jimp.newSpecialInvokeExpr(l_r4, scene.getMethod("<java.lang.NoClassDefFoundError: void <init>(java.lang.String)>").makeRef(), Collections.singletonList(l_r5))));
        units.add(jimp.newThrowStmt(l_r4));
        body.getTraps().add(jimp.newTrap(refTypeClassNotFoundException.getSootClass(), asi, handlerStart, handlerStart));
        if (createNewAsShimple) {
            body = Shimple.v().newBody(body);
        }
        method.setActiveBody(body);
        return method;
    }

    public void synchronizeStmtOn(Stmt stmt, JimpleBody b, Local lock) {
        this.synchronizeStmtOn(stmt, (Body)b, lock);
    }

    public void synchronizeStmtOn(Stmt stmt, ShimpleBody b, Local lock) {
        this.synchronizeStmtOn(stmt, (Body)b, lock);
    }

    void synchronizeStmtOn(Stmt stmt, Body b, Local lock) {
        assert (b instanceof JimpleBody || b instanceof ShimpleBody);
        Jimple jimp = Jimple.v();
        UnitPatchingChain units = b.getUnits();
        units.insertBefore(jimp.newEnterMonitorStmt(lock), stmt);
        ExitMonitorStmt exitMon = jimp.newExitMonitorStmt(lock);
        units.insertAfter(exitMon, stmt);
        GotoStmt newGoto = jimp.newGotoStmt(units.getSuccOf(exitMon));
        units.insertAfter(newGoto, exitMon);
        Local eRef = jimp.newLocal("__exception", Scene.v().getBaseExceptionType());
        b.getLocals().add(eRef);
        ArrayList<Unit> l = new ArrayList<Unit>();
        IdentityStmt handlerStmt = jimp.newIdentityStmt(eRef, jimp.newCaughtExceptionRef());
        l.add(handlerStmt);
        l.add((Unit)exitMon.clone());
        l.add(jimp.newThrowStmt(eRef));
        units.insertAfter(l, newGoto);
        b.getTraps().addFirst(jimp.newTrap(Scene.v().getSootClass(Scene.v().getBaseExceptionType().toString()), stmt, units.getSuccOf(stmt), handlerStmt));
    }
}

