/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.invoke;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.Body;
import soot.Local;
import soot.PhaseOptions;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Trap;
import soot.TrapManager;
import soot.Unit;
import soot.UnitBox;
import soot.UnitPatchingChain;
import soot.Value;
import soot.ValueBox;
import soot.jimple.AssignStmt;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.IdentityRef;
import soot.jimple.IdentityStmt;
import soot.jimple.IfStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.NullConstant;
import soot.jimple.ParameterRef;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.Stmt;
import soot.jimple.ThisRef;
import soot.jimple.toolkits.invoke.SynchronizerManager;
import soot.jimple.toolkits.invoke.ThrowManager;
import soot.jimple.toolkits.scalar.LocalNameStandardizer;
import soot.tagkit.Host;
import soot.util.Chain;

public class SiteInliner {
    public String getDefaultOptions() {
        return "insert-null-checks insert-redundant-casts";
    }

    public static void inlineSites(List<List<Host>> sites) {
        SiteInliner.inlineSites(sites, Collections.emptyMap());
    }

    public static void inlineSites(List<List<Host>> sites, Map<String, String> options) {
        for (List<Host> l : sites) {
            assert (l.size() == 3);
            SootMethod inlinee = (SootMethod)l.get(0);
            Stmt toInline = (Stmt)l.get(1);
            SootMethod container2 = (SootMethod)l.get(2);
            SiteInliner.inlineSite(inlinee, toInline, container2, options);
        }
    }

    public static List<Unit> inlineSite(SootMethod inlinee, Stmt toInline, SootMethod container2) {
        return SiteInliner.inlineSite(inlinee, toInline, container2, Collections.emptyMap());
    }

    public static List<Unit> inlineSite(SootMethod inlinee, Stmt toInline, SootMethod container2, Map<String, String> options) {
        Value base;
        Value thisToAdd;
        SootClass declaringClass = inlinee.getDeclaringClass();
        if (!declaringClass.isApplicationClass() && !declaringClass.isLibraryClass()) {
            return null;
        }
        Body containerB = container2.getActiveBody();
        UnitPatchingChain containerUnits = containerB.getUnits();
        assert (containerUnits.contains(toInline)) : toInline + " is not in body " + containerB;
        InvokeExpr ie = toInline.getInvokeExpr();
        Value value = thisToAdd = ie instanceof InstanceInvokeExpr ? ((InstanceInvokeExpr)ie).getBase() : null;
        if (ie instanceof InstanceInvokeExpr) {
            SootClass localType;
            if (PhaseOptions.getBoolean(options, "insert-redundant-casts") && ((localType = ((RefType)(base = ((InstanceInvokeExpr)ie).getBase()).getType()).getSootClass()).isInterface() || Scene.v().getActiveHierarchy().isClassSuperclassOf(localType, declaringClass))) {
                Jimple jimp = Jimple.v();
                RefType type = declaringClass.getType();
                Local castee = jimp.newLocal("__castee", type);
                containerB.getLocals().add(castee);
                containerUnits.insertBefore(jimp.newAssignStmt(castee, jimp.newCastExpr(base, type)), toInline);
                thisToAdd = castee;
            }
            if (PhaseOptions.getBoolean(options, "insert-null-checks")) {
                Jimple jimp = Jimple.v();
                if (TrapManager.isExceptionCaughtAt(Scene.v().getSootClass("java.lang.NullPointerException"), toInline, containerB)) {
                    IfStmt insertee = jimp.newIfStmt((Value)jimp.newNeExpr(((InstanceInvokeExpr)ie).getBase(), NullConstant.v()), toInline);
                    containerUnits.insertBefore(insertee, toInline);
                    insertee.setTarget(toInline);
                    ThrowManager.addThrowAfter(containerB.getLocals(), containerUnits, insertee);
                } else {
                    containerUnits.insertBefore(jimp.newIfStmt((Value)jimp.newEqExpr(((InstanceInvokeExpr)ie).getBase(), NullConstant.v()), ThrowManager.getNullPointerExceptionThrower(containerB)), toInline);
                }
            }
        }
        if (inlinee.isSynchronized()) {
            if (ie instanceof InstanceInvokeExpr) {
                base = (Local)((InstanceInvokeExpr)ie).getBase();
                SynchronizerManager.v().synchronizeStmtOn(toInline, containerB, (Local)base);
            } else if (!container2.getDeclaringClass().isInterface()) {
                SynchronizerManager mgr = SynchronizerManager.v();
                mgr.synchronizeStmtOn(toInline, containerB, mgr.addStmtsToFetchClassBefore(containerB, toInline));
            }
        }
        Body inlineeB = inlinee.getActiveBody();
        UnitPatchingChain inlineeUnits = inlineeB.getUnits();
        Unit exitPoint = containerUnits.getSuccOf(toInline);
        HashMap<Local, Local> oldLocalsToNew = new HashMap<Local, Local>();
        HashMap<Unit, Unit> oldUnitsToNew = new HashMap<Unit, Unit>();
        Unit cursor = toInline;
        for (Unit unit : inlineeUnits) {
            Unit unit2 = (Unit)unit.clone();
            if (unit2 == null) {
                throw new RuntimeException("getting null from clone!");
            }
            unit2.addAllTagsOf(unit);
            containerUnits.insertAfter(unit2, cursor);
            oldUnitsToNew.put(unit, unit2);
            cursor = unit2;
        }
        for (Local local : inlineeB.getLocals()) {
            Local local2 = (Local)local.clone();
            if (local2 == null) {
                throw new RuntimeException("getting null from local clone!");
            }
            containerB.getLocals().add(local2);
            oldLocalsToNew.put(local, local2);
        }
        Iterator<Unit> it = containerUnits.iterator((Unit)containerUnits.getSuccOf(toInline), containerUnits.getPredOf(exitPoint));
        while (it.hasNext()) {
            Unit patchee = it.next();
            for (ValueBox valueBox : patchee.getUseAndDefBoxes()) {
                Value value2 = valueBox.getValue();
                if (!(value2 instanceof Local)) continue;
                Local lPrime = (Local)oldLocalsToNew.get((Local)value2);
                if (lPrime == null) {
                    throw new RuntimeException("local has no clone!");
                }
                valueBox.setValue(lPrime);
            }
            for (UnitBox unitBox : patchee.getUnitBoxes()) {
                Unit uPrime = (Unit)oldUnitsToNew.get(unitBox.getUnit());
                if (uPrime == null) {
                    throw new RuntimeException("inlined stmt has no clone!");
                }
                unitBox.setUnit(uPrime);
            }
        }
        Chain<Trap> traps = containerB.getTraps();
        Trap prevTrap = null;
        for (Trap trap : inlineeB.getTraps()) {
            Unit newBegin = (Unit)oldUnitsToNew.get(trap.getBeginUnit());
            Unit newEnd = (Unit)oldUnitsToNew.get(trap.getEndUnit());
            Unit newHandler = (Unit)oldUnitsToNew.get(trap.getHandlerUnit());
            if (newBegin == null || newEnd == null || newHandler == null) {
                throw new RuntimeException("couldn't map trap!");
            }
            Trap trap2 = Jimple.v().newTrap(trap.getException(), newBegin, newEnd, newHandler);
            if (prevTrap == null) {
                traps.addFirst(trap2);
            } else {
                traps.insertAfter(trap2, prevTrap);
            }
            prevTrap = trap2;
        }
        ArrayList<Unit> cuCopy = new ArrayList<Unit>();
        Iterator<Unit> it2 = containerUnits.iterator((Unit)containerUnits.getSuccOf(toInline), containerUnits.getPredOf(exitPoint));
        while (it2.hasNext()) {
            cuCopy.add(it2.next());
        }
        for (Unit unit : cuCopy) {
            if (unit instanceof IdentityStmt) {
                IdentityStmt identityStmt = (IdentityStmt)unit;
                IdentityRef rhs = (IdentityRef)identityStmt.getRightOp();
                if (rhs instanceof CaughtExceptionRef) continue;
                if (rhs instanceof ThisRef) {
                    if (!(ie instanceof InstanceInvokeExpr)) {
                        throw new RuntimeException("thisref with no receiver!");
                    }
                    containerUnits.swapWith(unit, Jimple.v().newAssignStmt(identityStmt.getLeftOp(), thisToAdd));
                    continue;
                }
                if (!(rhs instanceof ParameterRef)) continue;
                ParameterRef pref = (ParameterRef)rhs;
                containerUnits.swapWith(unit, Jimple.v().newAssignStmt(identityStmt.getLeftOp(), ie.getArg(pref.getIndex())));
                continue;
            }
            if (unit instanceof ReturnStmt) {
                if (toInline instanceof InvokeStmt) {
                    containerUnits.swapWith(unit, Jimple.v().newGotoStmt(exitPoint));
                    continue;
                }
                if (toInline instanceof AssignStmt) {
                    Jimple jimple = Jimple.v();
                    AssignStmt as = jimple.newAssignStmt(((AssignStmt)toInline).getLeftOp(), ((ReturnStmt)unit).getOp());
                    containerUnits.insertBefore(as, unit);
                    containerUnits.swapWith(unit, jimple.newGotoStmt(exitPoint));
                    continue;
                }
                throw new RuntimeException("invoking stmt neither InvokeStmt nor AssignStmt!??!?!");
            }
            if (!(unit instanceof ReturnVoidStmt)) continue;
            containerUnits.swapWith(unit, Jimple.v().newGotoStmt(exitPoint));
        }
        ArrayList<Unit> newStmts = new ArrayList<Unit>();
        Iterator<Unit> i = containerUnits.iterator((Unit)containerUnits.getSuccOf(toInline), containerUnits.getPredOf(exitPoint));
        while (i.hasNext()) {
            newStmts.add(i.next());
        }
        containerUnits.remove(toInline);
        LocalNameStandardizer.v().transform(containerB, "ji.lns");
        return newStmts;
    }
}

