/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.ide.exampleproblems;

import heros.DefaultSeeds;
import heros.FlowFunction;
import heros.FlowFunctions;
import heros.InterproceduralCFG;
import heros.flowfunc.Identity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.Local;
import soot.NullType;
import soot.Scene;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.InvokeExpr;
import soot.jimple.ReturnStmt;
import soot.jimple.Stmt;
import soot.jimple.internal.JimpleLocal;
import soot.jimple.toolkits.ide.DefaultJimpleIFDSTabulationProblem;

public class IFDSLiveVariables
extends DefaultJimpleIFDSTabulationProblem<Value, InterproceduralCFG<Unit, SootMethod>> {
    public IFDSLiveVariables(InterproceduralCFG<Unit, SootMethod> icfg) {
        super(icfg);
    }

    @Override
    public FlowFunctions<Unit, Value, SootMethod> createFlowFunctionsFactory() {
        return new FlowFunctions<Unit, Value, SootMethod>(){

            @Override
            public FlowFunction<Value> getNormalFlowFunction(Unit curr, Unit succ) {
                if (curr.getUseAndDefBoxes().isEmpty()) {
                    return Identity.v();
                }
                final Stmt s2 = (Stmt)curr;
                return new FlowFunction<Value>(){

                    @Override
                    public Set<Value> computeTargets(Value source) {
                        List<ValueBox> defs = s2.getDefBoxes();
                        if (!defs.isEmpty() && defs.get(0).getValue().equivTo(source)) {
                            return Collections.emptySet();
                        }
                        if (source.equals(IFDSLiveVariables.this.zeroValue())) {
                            HashSet<Value> liveVars = new HashSet<Value>();
                            for (ValueBox useBox : s2.getUseBoxes()) {
                                Value value = useBox.getValue();
                                liveVars.add(value);
                            }
                            return liveVars;
                        }
                        return Collections.singleton(source);
                    }
                };
            }

            @Override
            public FlowFunction<Value> getCallFlowFunction(Unit callStmt, final SootMethod destinationMethod) {
                final Stmt s2 = (Stmt)callStmt;
                return new FlowFunction<Value>(){

                    @Override
                    public Set<Value> computeTargets(Value source) {
                        Value callerSideReturnValue;
                        if (!s2.getDefBoxes().isEmpty() && (callerSideReturnValue = s2.getDefBoxes().get(0).getValue()).equivTo(source)) {
                            HashSet<Value> calleeSideReturnValues = new HashSet<Value>();
                            for (Unit calleeUnit : IFDSLiveVariables.this.interproceduralCFG().getStartPointsOf((SootMethod)destinationMethod)) {
                                if (!(calleeUnit instanceof ReturnStmt)) continue;
                                ReturnStmt returnStmt = (ReturnStmt)calleeUnit;
                                calleeSideReturnValues.add(returnStmt.getOp());
                            }
                            return calleeSideReturnValues;
                        }
                        return Collections.emptySet();
                    }
                };
            }

            @Override
            public FlowFunction<Value> getReturnFlowFunction(Unit callSite, SootMethod calleeMethod, Unit exitStmt, Unit returnSite) {
                Stmt s2 = (Stmt)callSite;
                InvokeExpr ie = s2.getInvokeExpr();
                final List<Value> callArgs = ie.getArgs();
                final ArrayList<Local> paramLocals = new ArrayList<Local>();
                for (int i = 0; i < calleeMethod.getParameterCount(); ++i) {
                    paramLocals.add(calleeMethod.getActiveBody().getParameterLocal(i));
                }
                return new FlowFunction<Value>(){

                    @Override
                    public Set<Value> computeTargets(Value source) {
                        HashSet<Value> liveParamsAtCallee = new HashSet<Value>();
                        for (int i = 0; i < paramLocals.size(); ++i) {
                            if (!((Local)paramLocals.get(i)).equivTo(source)) continue;
                            liveParamsAtCallee.add((Value)callArgs.get(i));
                        }
                        return liveParamsAtCallee;
                    }
                };
            }

            @Override
            public FlowFunction<Value> getCallToReturnFlowFunction(Unit callSite, Unit returnSite) {
                if (callSite.getUseAndDefBoxes().isEmpty()) {
                    return Identity.v();
                }
                final Stmt s2 = (Stmt)callSite;
                return new FlowFunction<Value>(){

                    @Override
                    public Set<Value> computeTargets(Value source) {
                        List<ValueBox> defs = s2.getDefBoxes();
                        if (!defs.isEmpty() && defs.get(0).getValue().equivTo(source)) {
                            return Collections.emptySet();
                        }
                        if (source.equals(IFDSLiveVariables.this.zeroValue())) {
                            HashSet<Value> liveVars = new HashSet<Value>();
                            List<Value> args = s2.getInvokeExpr().getArgs();
                            for (ValueBox useBox : s2.getUseBoxes()) {
                                Value value = useBox.getValue();
                                if (args.contains(value)) continue;
                                liveVars.add(value);
                            }
                            return liveVars;
                        }
                        return Collections.singleton(source);
                    }
                };
            }
        };
    }

    @Override
    public Map<Unit, Set<Value>> initialSeeds() {
        return DefaultSeeds.make(this.interproceduralCFG().getStartPointsOf((SootMethod)Scene.v().getMainMethod()), (Value)this.zeroValue());
    }

    @Override
    public Value createZeroValue() {
        return new JimpleLocal("<<zero>>", NullType.v());
    }
}

