/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.BodyTransformer;
import soot.PhaseOptions;
import soot.Trap;
import soot.Unit;
import soot.jimple.GotoStmt;
import soot.jimple.IfStmt;
import soot.jimple.Jimple;
import soot.options.Options;
import soot.toolkits.graph.Block;
import soot.toolkits.graph.BriefBlockGraph;
import soot.util.Chain;

public class LoopConditionUnroller
extends BodyTransformer {
    private static final Logger logger = LoggerFactory.getLogger(LoopConditionUnroller.class);
    private Set<Block> visitingSuccs;
    private Set<Block> visitedBlocks;
    private int maxSize;
    private Chain<Unit> unitChain;
    private Chain<Trap> trapChain;
    private Map<Unit, List<Trap>> unitsToTraps;

    @Override
    protected void internalTransform(Body body, String phaseName, Map<String, String> options) {
        if (Options.v().verbose()) {
            logger.debug("[" + body.getMethod().getName() + "]     Unrolling Loop Conditions...");
        }
        this.visitingSuccs = new HashSet<Block>();
        this.visitedBlocks = new HashSet<Block>();
        this.maxSize = PhaseOptions.getInt(options, "maxSize");
        this.unitChain = body.getUnits();
        this.trapChain = body.getTraps();
        this.unitsToTraps = LoopConditionUnroller.mapBeginEndUnitToTrap(this.trapChain);
        BriefBlockGraph bg = new BriefBlockGraph(body);
        for (Block b : bg.getHeads()) {
            this.unrollConditions(b);
        }
        if (Options.v().verbose()) {
            logger.debug("[" + body.getMethod().getName() + "]     Unrolling Loop Conditions done.");
        }
    }

    private Unit insertGotoAfter(Unit node, Unit target) {
        GotoStmt newGoto = Jimple.v().newGotoStmt(target);
        this.unitChain.insertAfter(newGoto, node);
        return newGoto;
    }

    private Unit insertCloneAfter(Unit node, Unit toClone) {
        Unit clone = (Unit)toClone.clone();
        this.unitChain.insertAfter(clone, node);
        return clone;
    }

    private int getSize(Block block) {
        int size = 1;
        Chain<Unit> chain = this.unitChain;
        Unit unit = block.getHead();
        Unit e = block.getTail();
        while (unit != e) {
            ++size;
            unit = chain.getSuccOf(unit);
        }
        return size;
    }

    private static Map<Unit, List<Trap>> mapBeginEndUnitToTrap(Chain<Trap> trapChain) {
        HashMap<Unit, List<Trap>> unitsToTraps = new HashMap<Unit, List<Trap>>();
        for (Trap trap : trapChain) {
            Unit beginUnit = trap.getBeginUnit();
            ArrayList<Trap> unitTraps = (ArrayList<Trap>)unitsToTraps.get(beginUnit);
            if (unitTraps == null) {
                unitTraps = new ArrayList<Trap>();
                unitsToTraps.put(beginUnit, unitTraps);
            }
            unitTraps.add(trap);
            Unit endUnit = trap.getEndUnit();
            if (endUnit == beginUnit) continue;
            ArrayList<Trap> unitTraps2 = (ArrayList<Trap>)unitsToTraps.get(endUnit);
            if (unitTraps2 == null) {
                unitTraps2 = new ArrayList<Trap>();
                unitsToTraps.put(endUnit, unitTraps2);
            }
            unitTraps2.add(trap);
        }
        return unitsToTraps;
    }

    private Unit copyBlock(Block block) {
        Unit newGoto;
        HashSet<Trap> openedTraps = new HashSet<Trap>();
        HashMap<Trap, Trap> copiedTraps = new HashMap<Trap, Trap>();
        Chain<Unit> chain = this.unitChain;
        Unit tail = block.getTail();
        Unit last = newGoto = this.insertGotoAfter(tail, chain.getSuccOf(tail));
        Unit copiedHead = null;
        Unit curr = block.getHead();
        while (curr != newGoto) {
            List<Trap> currentTraps;
            last = this.insertCloneAfter(last, curr);
            if (copiedHead == null) {
                copiedHead = last;
                assert (copiedHead != null);
            }
            if ((currentTraps = this.unitsToTraps.get(curr)) != null) {
                for (Trap trap : currentTraps) {
                    Trap copiedTrap;
                    if (trap.getBeginUnit() == curr) {
                        copiedTrap = (Trap)trap.clone();
                        copiedTrap.setBeginUnit(last);
                        copiedTraps.put(trap, copiedTrap);
                        openedTraps.add(copiedTrap);
                        this.trapChain.insertAfter(copiedTrap, trap);
                    }
                    if (trap.getEndUnit() != curr) continue;
                    copiedTrap = (Trap)copiedTraps.get(trap);
                    if (copiedTrap == null) {
                        copiedTrap = (Trap)trap.clone();
                        copiedTrap.setBeginUnit(copiedHead);
                        this.trapChain.insertAfter(copiedTrap, trap);
                    } else {
                        openedTraps.remove(copiedTrap);
                    }
                    copiedTrap.setEndUnit(last);
                }
            }
            curr = chain.getSuccOf(curr);
        }
        for (Trap t2 : openedTraps) {
            t2.setEndUnit(last);
        }
        return copiedHead;
    }

    private void unrollConditions(Block block) {
        if (this.visitedBlocks.contains(block)) {
            return;
        }
        this.visitedBlocks.add(block);
        this.visitingSuccs.add(block);
        for (Block succ : block.getSuccs()) {
            if (this.visitedBlocks.contains(succ)) {
                if (succ == block || !this.visitingSuccs.contains(succ) || succ.getPreds().size() < 2 || succ.getSuccs().size() != 2) continue;
                Block condition = succ;
                Block loopTailBlock = block;
                if (this.getSize(condition) > this.maxSize) continue;
                Unit copiedHead = this.copyBlock(condition);
                Unit loopTail = loopTailBlock.getTail();
                if (loopTail instanceof GotoStmt) {
                    ((GotoStmt)loopTail).setTarget(copiedHead);
                    continue;
                }
                if (loopTail instanceof IfStmt) {
                    IfStmt tailIf = (IfStmt)loopTail;
                    if (tailIf.getTarget() == condition.getHead()) {
                        tailIf.setTarget(copiedHead);
                        continue;
                    }
                    this.insertGotoAfter(loopTail, copiedHead);
                    continue;
                }
                this.insertGotoAfter(loopTail, copiedHead);
                continue;
            }
            this.unrollConditions(succ);
        }
        this.visitingSuccs.remove(block);
    }
}

